/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;

public class CaveSugarWaterfall
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();

    public CaveSugarWaterfall(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int neededNumberOfSides;
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos().set((Vec3i)context.origin());
        BlockState blockstate = context.level().getBlockState(blockpos$Mutable.above());
        if (!blockstate.canOcclude() || blockstate.is(BzTags.HONEYCOMBS_THAT_FEATURES_CAN_CARVE)) {
            return false;
        }
        int numberOfSolidSides = 0;
        blockstate = context.level().getBlockState(blockpos$Mutable.below());
        if (blockstate.canOcclude() && blockstate.is(BzTags.HONEYCOMBS_THAT_FEATURES_CAN_CARVE)) {
            neededNumberOfSides = 3;
        } else if (blockstate.getBlock() == CAVE_AIR.getBlock()) {
            neededNumberOfSides = 4;
        } else {
            return false;
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            blockstate = context.level().getBlockState(blockpos$Mutable.relative(face));
            if (blockstate.canOcclude() && blockstate.is(BzTags.HONEYCOMBS_THAT_FEATURES_CAN_CARVE)) {
                ++numberOfSolidSides;
                continue;
            }
            if (blockstate.getBlock() == CAVE_AIR.getBlock()) continue;
            return false;
        }
        if (numberOfSolidSides == neededNumberOfSides) {
            context.level().setBlock((BlockPos)blockpos$Mutable, ((LiquidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).defaultBlockState(), 2);
            context.level().scheduleTick((BlockPos)blockpos$Mutable, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), 0);
        }
        return true;
    }
}

