/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.items.recipes.PotionCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class FakePotionCandleRecipeCreator {
    public static List<CraftingRecipe> constructFakeRecipes(PotionCandleRecipe potionCandleRecipe, boolean oneRecipeOnly) {
        ArrayList<CraftingRecipe> extraRecipes = new ArrayList<CraftingRecipe>();
        HashSet effects = new HashSet();
        ArrayList<Holder> potions = new ArrayList<Holder>();
        for (ResourceLocation potionKey : BuiltInRegistries.POTION.keySet()) {
            Optional potion = BuiltInRegistries.POTION.getHolder(potionKey);
            if (oneRecipeOnly && !potions.isEmpty()) break;
            if (potion.isEmpty() || ((Potion)((Holder.Reference)potion.get()).value()).getEffects().stream().allMatch(e -> effects.contains(e.getEffect().value()) || BuiltInRegistries.MOB_EFFECT.getHolderOrThrow((ResourceKey)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)((MobEffect)e.getEffect().value())).orElseThrow()).is(BzTags.DISALLOWED_POTION_CANDLE_EFFECTS))) continue;
            ((Potion)((Holder.Reference)potion.get()).value()).getEffects().forEach(e -> effects.add((MobEffect)e.getEffect().value()));
            potions.add((Holder)potion.get());
        }
        potions.sort(Comparator.comparingInt(a -> ((Potion)a.value()).getEffects().size()));
        for (Holder potion : potions) {
            if (((Potion)potion.value()).getEffects().stream().allMatch(e -> e.getEffect().is(BzTags.DISALLOWED_POTION_CANDLE_EFFECTS))) continue;
            FakePotionCandleRecipeCreator.addRecipeIfValid(extraRecipes, FakePotionCandleRecipeCreator.getFakeShapedRecipe(potionCandleRecipe, (Holder<Potion>)potion, Items.POTION.getDefaultInstance()));
            FakePotionCandleRecipeCreator.addRecipeIfValid(extraRecipes, FakePotionCandleRecipeCreator.getFakeShapedRecipe(potionCandleRecipe, (Holder<Potion>)potion, Items.SPLASH_POTION.getDefaultInstance()));
            FakePotionCandleRecipeCreator.addRecipeIfValid(extraRecipes, FakePotionCandleRecipeCreator.getFakeShapedRecipe(potionCandleRecipe, (Holder<Potion>)potion, Items.LINGERING_POTION.getDefaultInstance()));
        }
        return extraRecipes;
    }

    private static void addRecipeIfValid(List<CraftingRecipe> extraRecipes, ShapedRecipe recipe) {
        if (!recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).isEmpty()) {
            extraRecipes.add((CraftingRecipe)recipe);
        }
    }

    private static ShapedRecipe getFakeShapedRecipe(PotionCandleRecipe recipe, Holder<Potion> potion, ItemStack potionItem) {
        ItemStack potionStack = PotionContents.createItemStack((Item)potionItem.getItem(), potion);
        ArrayList<Ingredient> fakedShapedIngredientsMutable = new ArrayList<Ingredient>();
        for (int i = 0; i < 9; ++i) {
            fakedShapedIngredientsMutable.add(Ingredient.EMPTY);
        }
        int currentShapedIndex = 0;
        int shapedRecipeSize = recipe.getShapedRecipeItems().size();
        for (int x = 0; x < recipe.getWidth(); ++x) {
            for (int z = 0; z < recipe.getHeight(); ++z) {
                if (currentShapedIndex >= shapedRecipeSize) continue;
                Ingredient ingredient = (Ingredient)recipe.getShapedRecipeItems().get(currentShapedIndex);
                fakedShapedIngredientsMutable.set(x + z * 3, ingredient);
                ++currentShapedIndex;
            }
        }
        int currentShapelessIndex = 0;
        int shapelessRecipeSize = recipe.getShapelessRecipeItems().size();
        for (int i = 0; i < 9; ++i) {
            Ingredient ingredient = (Ingredient)fakedShapedIngredientsMutable.get(i);
            if (!ingredient.isEmpty()) continue;
            if (currentShapelessIndex >= shapelessRecipeSize) {
                fakedShapedIngredientsMutable.set(i, Ingredient.of((ItemStack[])new ItemStack[]{potionStack}));
                break;
            }
            fakedShapedIngredientsMutable.set(i, (Ingredient)recipe.getShapelessRecipeItems().get(currentShapelessIndex));
            ++currentShapelessIndex;
        }
        NonNullList fakedShapedIngredients = NonNullList.create();
        fakedShapedIngredients.addAll(fakedShapedIngredientsMutable);
        return new ShapedRecipe("the_bumblezone:potion_candle", CraftingBookCategory.MISC, new ShapedRecipePattern(3, 3, fakedShapedIngredients, Optional.empty()), FakePotionCandleRecipeCreator.createResultStack(recipe, potionStack));
    }

    private static ItemStack createResultStack(PotionCandleRecipe recipe, ItemStack potionStack) {
        ArrayList effects = new ArrayList();
        AtomicInteger maxDuration = new AtomicInteger();
        AtomicInteger effectLevel = new AtomicInteger();
        AtomicInteger potionEffectsFound = new AtomicInteger();
        ((PotionContents)potionStack.get(DataComponents.POTION_CONTENTS)).getAllEffects().forEach(me -> {
            effects.add((MobEffect)me.getEffect().value());
            maxDuration.addAndGet(((MobEffect)me.getEffect().value()).isInstantenous() ? 200 : me.getDuration());
            effectLevel.addAndGet(me.getAmplifier() + 1);
            potionEffectsFound.getAndIncrement();
        });
        if (effects.isEmpty()) {
            return ItemStack.EMPTY;
        }
        HashSet setPicker = new HashSet(effects);
        MobEffect chosenEffect = (MobEffect)setPicker.stream().toList().get(new Random().nextInt(setPicker.size()));
        if (chosenEffect == null) {
            return ItemStack.EMPTY;
        }
        PotionCandleRecipe.balanceMainStats(chosenEffect, maxDuration, effectLevel, potionEffectsFound);
        effectLevel.set(Math.min(effectLevel.get(), recipe.getMaxLevelCap()));
        return PotionCandleRecipe.createTaggedPotionCandle(chosenEffect, maxDuration, effectLevel, potionStack.getItem() instanceof SplashPotionItem ? 1 : 0, potionStack.getItem() instanceof LingeringPotionItem ? 1 : 0, recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getCount());
    }
}

