/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.CrystallineFlowerBlockEntity;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.HoneyCocoonBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzLootFunctionTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class DropContainerLoot
extends LootItemConditionalFunction {
    public static final MapCodec<DropContainerLoot> CODEC = RecordCodecBuilder.mapCodec(instance -> DropContainerLoot.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, DropContainerLoot::new));

    public DropContainerLoot(List<LootItemCondition> itemConditions) {
        super(itemConditions);
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)BzLootFunctionTypes.DROP_CONTAINER_ITEMS.get();
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        ServerLevel level = lootContext.getLevel();
        Vec3 spawnPos = (Vec3)lootContext.getParamOrNull(LootContextParams.ORIGIN);
        BlockEntity be = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (spawnPos != null && be instanceof Container) {
            HoneyCocoonBlockEntity honeyCocoonBlockEntity;
            Container container = (Container)be;
            if (!(ModChecker.lootrPresent && BzModCompatibilityConfigs.allowLootrCompat && container instanceof HoneyCocoonBlockEntity && (honeyCocoonBlockEntity = (HoneyCocoonBlockEntity)container).getLootTable() != null)) {
                Containers.dropContents((Level)level, (BlockPos)BlockPos.containing((Position)spawnPos), (Container)container);
            }
        } else if (spawnPos != null && be instanceof CrystallineFlowerBlockEntity) {
            ItemStack consumeItems;
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)be;
            BlockPos itemDropPos = BlockPos.containing((Position)spawnPos);
            ItemStack bookItems = crystallineFlowerBlockEntity.getBookSlotItems();
            if (!bookItems.isEmpty()) {
                Containers.dropItemStack((Level)level, (double)itemDropPos.getX(), (double)itemDropPos.getY(), (double)itemDropPos.getZ(), (ItemStack)bookItems);
            }
            if (!(consumeItems = crystallineFlowerBlockEntity.getConsumeSlotItems()).isEmpty()) {
                Containers.dropItemStack((Level)level, (double)itemDropPos.getX(), (double)itemDropPos.getY(), (double)itemDropPos.getZ(), (ItemStack)consumeItems);
            }
        }
        return itemStack;
    }
}

