/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.entities.nonliving.DirtPelletEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class DirtPellet
extends Item
implements ProjectileItem {
    public DirtPellet(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player playerEntity, InteractionHand hand) {
        ItemStack itemstack = playerEntity.getItemInHand(hand);
        if (!world.isClientSide()) {
            world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), (SoundEvent)BzSounds.DIRT_PELLET_THROW.get(), SoundSource.PLAYERS, 0.5f, 0.4f / (playerEntity.getRandom().nextFloat() * 0.4f + 0.8f));
            DirtPelletEntity pelletEntity = new DirtPelletEntity(world, (LivingEntity)playerEntity);
            pelletEntity.setItem(itemstack);
            pelletEntity.shootFromRotation((Entity)playerEntity, playerEntity.getXRot(), playerEntity.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)pelletEntity);
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!playerEntity.isCreative()) {
                itemstack.shrink(1);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)world.isClientSide());
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        DirtPelletEntity dirtPelletEntity = new DirtPelletEntity(level, position.x(), position.y(), position.z());
        dirtPelletEntity.setItem(itemStack);
        return dirtPelletEntity;
    }
}

