/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.fluids.base.BzBucketItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import dev.architectury.injectables.annotations.PlatformOnly;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BzCustomBucketItem
extends BzBucketItem {
    public final Fluid fluid;

    public BzCustomBucketItem(FluidData info, Item.Properties builder) {
        super(info, builder);
        this.fluid = ((FlowingFluid)info.still().get()).getSource();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player playerEntity, InteractionHand hand) {
        InteractionResultHolder<ItemStack> specialActionResult = PlatformHooks.performItemUse(world, playerEntity, hand, this.fluid, this);
        if (specialActionResult.getResult() != InteractionResult.PASS) {
            this.checkAndGrantAdvancement(world, playerEntity, specialActionResult);
            return specialActionResult;
        }
        InteractionResultHolder actionResult = super.use(world, playerEntity, hand);
        this.checkAndGrantAdvancement(world, playerEntity, (InteractionResultHolder<ItemStack>)actionResult);
        return actionResult;
    }

    private void checkAndGrantAdvancement(Level world, Player playerEntity, InteractionResultHolder<ItemStack> actionResult) {
        if (this.getFluid() == BzFluids.SUGAR_WATER_FLUID.get() && (actionResult.getResult() == InteractionResult.CONSUME || actionResult.getResult() == InteractionResult.SUCCESS) && playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            BlockHitResult raytraceresult = BzCustomBucketItem.getPlayerPOVHitResult((Level)world, (Player)playerEntity, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (raytraceresult.getType() == HitResult.Type.BLOCK) {
                BlockPos blockpos = raytraceresult.getBlockPos();
                Direction direction = raytraceresult.getDirection();
                BlockPos blockpos1 = blockpos.relative(direction);
                BlockState blockstate = world.getBlockState(blockpos);
                BlockPos blockpos2 = this.canBlockContainFluid(world, blockpos, blockstate) ? blockpos : blockpos1;
                boolean isNextToSugarCane = false;
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (Direction directionOffset : Direction.Plane.HORIZONTAL) {
                    mutable.set((Vec3i)blockpos2).move(directionOffset).move(Direction.UP);
                    BlockState state = world.getBlockState((BlockPos)mutable);
                    if (!state.is(Blocks.SUGAR_CANE)) continue;
                    isNextToSugarCane = true;
                    break;
                }
                if (isNextToSugarCane) {
                    ((GenericTrigger)((Object)BzCriterias.SUGAR_WATER_NEXT_TO_SUGAR_CANE_TRIGGER.get())).trigger(serverPlayer);
                }
            }
        }
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.getBlock() instanceof LiquidBlockContainer && (((LiquidBlockContainer)blockstate.getBlock()).canPlaceLiquid(null, (BlockGetter)worldIn, posIn, blockstate, (Fluid)this.getFluid()) || ((LiquidBlockContainer)blockstate.getBlock()).canPlaceLiquid(null, (BlockGetter)worldIn, posIn, blockstate, (Fluid)Fluids.WATER));
    }

    @PlatformOnly(value={"neoforge"})
    public boolean emptyContents(@Nullable Player player, Level world, BlockPos pos, @Nullable BlockHitResult hitResult, @Nullable ItemStack container) {
        return this.emptyContents(player, world, pos, hitResult);
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult hitResult) {
        if (!(this.fluid instanceof FlowingFluid) || !GeneralUtils.isPermissionAllowedAtSpot(level, (Entity)player, pos, true)) {
            return false;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        boolean canBucketPlace = blockState.canBeReplaced(this.fluid);
        boolean canPlaceFluid = blockState.isAir() || canBucketPlace;
        boolean feedVanillaWaterOverride = false;
        if (block instanceof LiquidBlockContainer) {
            if (((LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, pos, blockState, this.fluid)) {
                canPlaceFluid = true;
            }
            if (this.fluid.is(FluidTags.WATER) && ((LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, pos, blockState, (Fluid)Fluids.WATER)) {
                canPlaceFluid = true;
                feedVanillaWaterOverride = true;
            }
        }
        if (!canPlaceFluid) {
            return hitResult != null && this.emptyContents(player, level, hitResult.getBlockPos().relative(hitResult.getDirection()), null);
        }
        if (level.dimensionType().ultraWarm() && this.info.properties().canExtinguish()) {
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            level.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x + Math.random(), y + Math.random(), z + Math.random(), 0.0, 0.0, 0.0);
            }
            if (!level.isClientSide()) {
                if (this.fluid.is(BzTags.SUGAR_WATER_FLUID) && level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
                    Vec3 targetPos = hitResult != null ? hitResult.getLocation() : new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                    LootTable sugarWaterEvaporateLootTable = serverLevelAccessor.getLevel().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"fluids/sugar_water_evaporates")));
                    if (sugarWaterEvaporateLootTable != null) {
                        LootParams lootParams = new LootParams.Builder(serverLevelAccessor.getLevel()).withParameter(LootContextParams.ORIGIN, (Object)targetPos).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.COMMAND);
                        ObjectArrayList evaporateItems = sugarWaterEvaporateLootTable.getRandomItems(lootParams);
                        for (ItemStack itemStackToSpawn : evaporateItems) {
                            ItemEntity itementity = new ItemEntity(level, targetPos.x(), targetPos.y(), targetPos.z(), itemStackToSpawn);
                            itementity.setDefaultPickUpDelay();
                            level.addFreshEntity((Entity)itementity);
                        }
                    }
                } else if (this.fluid.is(BzTags.HONEY_FLUID)) {
                    level.setBlock(pos, ((Block)BzBlocks.GLISTERING_HONEY_CRYSTAL.get()).defaultBlockState(), 3);
                }
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && this.fluid.is(FluidTags.WATER)) {
            if (feedVanillaWaterOverride) {
                ((LiquidBlockContainer)block).placeLiquid((LevelAccessor)level, pos, blockState, Fluids.WATER.getSource(false));
            } else {
                ((LiquidBlockContainer)block).placeLiquid((LevelAccessor)level, pos, blockState, ((FlowingFluid)this.fluid).getSource(false));
            }
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.isClientSide && canBucketPlace && blockState.getFluidState().isEmpty()) {
            level.destroyBlock(pos, true);
        }
        if (!level.setBlock(pos, this.fluid.defaultFluidState().createLegacyBlock(), 11) && !blockState.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }
}

