/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminState;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class RootminEmbarrassedCurseGoal
extends Goal {
    protected final RootminEntity mob;
    protected int timer = 0;

    public RootminEmbarrassedCurseGoal(RootminEntity pathfinderMob) {
        this.mob = pathfinderMob;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        boolean isCursing = this.mob.getRootminPose() == RootminState.CURSE;
        boolean isEmbarrassed = this.mob.getRootminPose() == RootminState.EMBARRASSED;
        return this.mob.rootminToLookAt != null && (isCursing || isEmbarrassed);
    }

    public boolean canContinueToUse() {
        return this.timer > 0 && this.mob.rootminToLookAt != null && !this.mob.isDeadOrDying() && (this.mob.getRootminPose() == RootminState.CURSE || this.mob.getRootminPose() == RootminState.EMBARRASSED);
    }

    public void start() {
        this.timer = 40;
    }

    public void stop() {
        this.timer = 0;
        this.mob.disableAttackGoals = false;
        this.mob.rootminToLookAt = null;
        this.mob.exposedTimer = 0;
        this.mob.setRootminPose(RootminState.NONE);
    }

    public void tick() {
        this.mob.getNavigation().stop();
        if (this.mob.rootminToLookAt == null) {
            this.timer = 0;
        } else {
            this.mob.lookAt((Entity)this.mob.rootminToLookAt, 30.0f, 30.0f);
            --this.timer;
        }
    }
}

