/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.fluids;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.fluid.data.ClientFluidProperties;
import com.telepathicgrunt.the_bumblezone.client.rendering.fluids.FluidClientOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class SugarWaterClientProperties {
    public static final ResourceLocation FLUID_STILL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"block/sugar_water/still");
    public static final ResourceLocation FLUID_FLOWING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"block/sugar_water/flow");
    public static final ResourceLocation FLUID_OVERLAY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"block/sugar_water/overlay");
    public static final ResourceLocation TEXTURE_UNDERWATER = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/misc/sugar_water_underwater.png");

    public static ClientFluidProperties create() {
        return new ClientFluidProperties(){

            public ResourceLocation still(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                return FLUID_STILL_TEXTURE;
            }

            public ResourceLocation flowing(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                return FLUID_FLOWING_TEXTURE;
            }

            public ResourceLocation overlay(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                return FLUID_OVERLAY_TEXTURE;
            }

            public ResourceLocation screenOverlay() {
                return TEXTURE_UNDERWATER;
            }

            public void renderOverlay(Minecraft minecraft, PoseStack stack) {
                FluidClientOverlay.renderHoneyOverlay((Player)minecraft.player, stack);
            }

            public int tintColor(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                if (view != null && pos != null) {
                    return BiomeColors.getAverageWaterColor((BlockAndTintGetter)view, (BlockPos)pos) | 0xFF000000;
                }
                return -11106846;
            }
        };
    }
}

