/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class HoneyWeb
extends Block {
    public static final BooleanProperty NORTHSOUTH = BooleanProperty.create((String)"northsouth");
    public static final BooleanProperty EASTWEST = BooleanProperty.create((String)"eastwest");
    public static final BooleanProperty UPDOWN = BooleanProperty.create((String)"updown");
    protected final VoxelShape[] collisionShapeByIndex;
    protected final VoxelShape[] shapeByIndex;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();
    public static final Map<Direction.Axis, BooleanProperty> AXIS_TO_PROP = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.Axis.class), map -> {
        map.put(Direction.Axis.X, NORTHSOUTH);
        map.put(Direction.Axis.Z, EASTWEST);
        map.put(Direction.Axis.Y, UPDOWN);
    })));
    public static final MapCodec<HoneyWeb> CODEC = Block.simpleCodec(HoneyWeb::new);

    public HoneyWeb() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).forceSolidOn().noOcclusion().noCollission().requiresCorrectToolForDrops().strength(4.0f).pushReaction(PushReaction.DESTROY));
    }

    public HoneyWeb(BlockBehaviour.Properties properties) {
        super(properties);
        this.collisionShapeByIndex = this.makeShapes();
        this.shapeByIndex = this.makeShapes();
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EASTWEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UPDOWN, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends HoneyWeb> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{NORTHSOUTH, EASTWEST, UPDOWN});
    }

    protected VoxelShape[] makeShapes() {
        VoxelShape voxelshape1 = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape2 = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        VoxelShape voxelshape3 = Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
        return new VoxelShape[]{Shapes.empty(), voxelshape1, voxelshape2, Shapes.or((VoxelShape)voxelshape1, (VoxelShape)voxelshape2), voxelshape3, Shapes.or((VoxelShape)voxelshape1, (VoxelShape)voxelshape3), Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape3), Shapes.joinUnoptimized((VoxelShape)Shapes.joinUnoptimized((VoxelShape)voxelshape1, (VoxelShape)voxelshape2, (BooleanOp)BooleanOp.OR), (VoxelShape)voxelshape3, (BooleanOp)BooleanOp.OR).optimize()};
    }

    private static int getNewBitFlag(BlockState blockState) {
        int bitFlag = 0;
        if (((Boolean)blockState.getValue((Property)NORTHSOUTH)).booleanValue()) {
            bitFlag |= 1;
        }
        if (((Boolean)blockState.getValue((Property)EASTWEST)).booleanValue()) {
            bitFlag |= 2;
        }
        if (((Boolean)blockState.getValue((Property)UPDOWN)).booleanValue()) {
            bitFlag |= 4;
        }
        return bitFlag;
    }

    protected int getAABBIndex(BlockState blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, HoneyWeb::getNewBitFlag);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.shapeByIndex[this.getAABBIndex(blockState)];
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        Player player;
        if (entity.getType().is(BzTags.HONEY_WEB_CANNOT_SLOW)) {
            super.entityInside(blockState, level, blockPos, entity);
            return;
        }
        if (!(entity instanceof Player) || !(player = (Player)entity).isCreative()) {
            ItemStack itemStack;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                itemStack = HoneyBeeLeggings.getEntityBeeLegging(livingEntity);
            } else {
                itemStack = ItemStack.EMPTY;
            }
            ItemStack beeLeggings = itemStack;
            VoxelShape shape = this.shapeByIndex[this.getAABBIndex(blockState)];
            shape = shape.move((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
            if (Shapes.joinIsNotEmpty((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)entity.getBoundingBox()), (BooleanOp)BooleanOp.AND)) {
                if (entity instanceof Projectile) {
                    speedReduction = 0.015f;
                    Vec3 deltaMovement = entity.getDeltaMovement();
                    double magnitude = deltaMovement.length();
                    if (magnitude != 0.0) {
                        entity.makeStuckInBlock(blockState, new Vec3(speedReduction /= magnitude, speedReduction, speedReduction));
                    }
                } else {
                    speedReduction = 0.1f;
                    if (!beeLeggings.isEmpty()) {
                        speedReduction = 0.9f;
                    } else {
                        Vec3 deltaMovement = entity.getDeltaMovement();
                        double magnitude = deltaMovement.length();
                        if (magnitude != 0.0) {
                            speedReduction /= magnitude;
                        }
                    }
                    entity.makeStuckInBlock(blockState, new Vec3(speedReduction, speedReduction, speedReduction));
                }
                if (beeLeggings.isEmpty() && entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1, false, false, true));
                }
            }
        }
        super.entityInside(blockState, level, blockPos, entity);
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        BlockPos blockpos;
        Level level = placeContext.getLevel();
        BlockState state = this.getStateForSpot((BlockGetter)level, blockpos = placeContext.getClickedPos());
        if (!(((Boolean)state.getValue((Property)NORTHSOUTH)).booleanValue() || ((Boolean)state.getValue((Property)EASTWEST)).booleanValue() || ((Boolean)state.getValue((Property)UPDOWN)).booleanValue())) {
            if (placeContext.getClickedFace().getAxis() != Direction.Axis.Y) {
                state = (BlockState)this.defaultBlockState().setValue((Property)UPDOWN, (Comparable)Boolean.valueOf(true));
            } else {
                Direction.Axis horizontalFacing = Direction.Axis.Z;
                for (Direction direction : placeContext.getNearestLookingDirections()) {
                    if (direction.getAxis() == Direction.Axis.Y) continue;
                    horizontalFacing = direction.getAxis();
                    break;
                }
                state = horizontalFacing == Direction.Axis.X ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)EASTWEST, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EASTWEST, (Comparable)Boolean.valueOf(true));
            }
        }
        this.updateNeighboringStates(level, state, blockpos);
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        if (itemStack.is(BzTags.WASHING_ITEMS) && (!itemStack.is(Items.POTION) || itemStack.getComponents().has(DataComponents.POTION_CONTENTS) && ((PotionContents)itemStack.getComponents().get(DataComponents.POTION_CONTENTS)).is(Potions.WATER))) {
            if (!itemStack.isEmpty()) {
                playerEntity.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
            }
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                ((GenericTrigger)((Object)BzCriterias.CLEANUP_HONEY_WEB_TRIGGER.get())).trigger(serverPlayer);
            }
            level.destroyBlock(position, false);
            level.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), (SoundEvent)BzSounds.WASHING_RESIDUES.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (level.isClientSide()) {
                for (int i = 0; i < 25; ++i) {
                    this.addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, level, playerEntity.getRandom(), position, blockState.getShape((BlockGetter)level, position));
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, position, playerEntity, playerHand, raytraceResult);
    }

    private void updateNeighboringStates(Level level, BlockState centerState, BlockPos blockpos) {
        for (Direction direction : Direction.values()) {
            BlockPos sidePos = blockpos.relative(direction);
            BlockState neighboringBlockstate = level.getBlockState(sidePos);
            if (!(neighboringBlockstate.getBlock() instanceof HoneyWeb)) continue;
            boolean changedState = false;
            if (direction.getAxis() != Direction.Axis.X && ((Boolean)centerState.getValue((Property)NORTHSOUTH)).booleanValue() && !((Boolean)neighboringBlockstate.getValue((Property)NORTHSOUTH)).booleanValue()) {
                neighboringBlockstate = (BlockState)neighboringBlockstate.setValue((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (direction.getAxis() != Direction.Axis.Z && ((Boolean)centerState.getValue((Property)EASTWEST)).booleanValue() && !((Boolean)neighboringBlockstate.getValue((Property)EASTWEST)).booleanValue()) {
                neighboringBlockstate = (BlockState)neighboringBlockstate.setValue((Property)EASTWEST, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (direction.getAxis() != Direction.Axis.Y && ((Boolean)centerState.getValue((Property)UPDOWN)).booleanValue() && !((Boolean)neighboringBlockstate.getValue((Property)UPDOWN)).booleanValue()) {
                neighboringBlockstate = (BlockState)neighboringBlockstate.setValue((Property)UPDOWN, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (!changedState) continue;
            level.setBlock(sidePos, neighboringBlockstate, 3);
        }
    }

    @NotNull
    private BlockState getStateForSpot(BlockGetter blockgetter, BlockPos blockpos) {
        BlockState currentBlockstate = this.defaultBlockState();
        for (Direction direction : Direction.values()) {
            BlockState neighboringBlockstate = blockgetter.getBlockState(blockpos.relative(direction));
            if (!(neighboringBlockstate.getBlock() instanceof HoneyWeb)) continue;
            if (direction.getAxis() == Direction.Axis.Y) {
                if (((Boolean)neighboringBlockstate.getValue((Property)NORTHSOUTH)).booleanValue()) {
                    currentBlockstate = (BlockState)currentBlockstate.setValue((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
                }
                if (!((Boolean)neighboringBlockstate.getValue((Property)EASTWEST)).booleanValue()) continue;
                currentBlockstate = (BlockState)currentBlockstate.setValue((Property)EASTWEST, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (direction.getAxis() == Direction.Axis.X) {
                if (((Boolean)neighboringBlockstate.getValue((Property)UPDOWN)).booleanValue()) {
                    currentBlockstate = (BlockState)currentBlockstate.setValue((Property)UPDOWN, (Comparable)Boolean.valueOf(true));
                }
                if (!((Boolean)neighboringBlockstate.getValue((Property)EASTWEST)).booleanValue()) continue;
                currentBlockstate = (BlockState)currentBlockstate.setValue((Property)EASTWEST, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (direction.getAxis() != Direction.Axis.Z) continue;
            if (((Boolean)neighboringBlockstate.getValue((Property)UPDOWN)).booleanValue()) {
                currentBlockstate = (BlockState)currentBlockstate.setValue((Property)UPDOWN, (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)neighboringBlockstate.getValue((Property)NORTHSOUTH)).booleanValue()) continue;
            currentBlockstate = (BlockState)currentBlockstate.setValue((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
        }
        return currentBlockstate;
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)blockState.setValue((Property)NORTHSOUTH, (Comparable)((Boolean)blockState.getValue((Property)EASTWEST)))).setValue((Property)EASTWEST, (Comparable)((Boolean)blockState.getValue((Property)NORTHSOUTH)));
            default -> blockState;
        };
    }

    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        for (int i = 0; i == random.nextInt(50); ++i) {
            this.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, world, random, position, blockState.getShape((BlockGetter)world, position));
        }
    }

    protected void addParticle(ParticleOptions particleType, Level world, RandomSource random, BlockPos blockPos, VoxelShape blockShape) {
        this.addParticle(particleType, world, random, (double)blockPos.getX() + blockShape.min(Direction.Axis.X), (double)blockPos.getX() + blockShape.max(Direction.Axis.X), (double)blockPos.getY() + blockShape.min(Direction.Axis.Y), (double)blockPos.getY() + blockShape.max(Direction.Axis.Y), (double)blockPos.getZ() + blockShape.min(Direction.Axis.Z), (double)blockPos.getZ() + blockShape.max(Direction.Axis.Z));
    }

    private void addParticle(ParticleOptions particleType, Level world, RandomSource random, double xMin, double xMax, double yMin, double yMax, double zMax, double zMin) {
        world.addParticle(particleType, Mth.lerp((double)random.nextDouble(), (double)xMin, (double)xMax), Mth.lerp((double)random.nextDouble(), (double)yMin, (double)yMax), Mth.lerp((double)random.nextDouble(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }
}

