/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataModule;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;

public class KilledCounterTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer, Entity currentEntity, PlayerDataModule module) {
        super.trigger(serverPlayer, trigger -> trigger.matches(serverPlayer, currentEntity, module));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, int targetCount, ResourceLocation targetEntity, boolean isTargetTag, boolean beeArmorRequired) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ExtraCodecs.POSITIVE_INT.fieldOf("target_count").forGetter(TriggerInstance::targetCount), (App)ResourceLocation.CODEC.fieldOf("target_entity").forGetter(TriggerInstance::targetEntity), (App)Codec.BOOL.fieldOf("is_target_tag").orElse((Object)false).forGetter(TriggerInstance::isTargetTag), (App)Codec.BOOL.fieldOf("bee_armor_required").orElse((Object)false).forGetter(TriggerInstance::beeArmorRequired)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer serverPlayer, Entity currentEntity, PlayerDataModule module) {
            boolean entityMatch = this.isTargetTag ? currentEntity.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)this.targetEntity)) : BuiltInRegistries.ENTITY_TYPE.getKey((Object)currentEntity.getType()).equals((Object)this.targetEntity);
            int currentCount = 0;
            if (entityMatch) {
                module.mobsKilledTracker.merge((Object)this.targetEntity, 1, Integer::sum);
                currentCount = module.mobsKilledTracker.get((Object)this.targetEntity);
            }
            return entityMatch && (!this.beeArmorRequired || BeeArmor.getBeeThemedWearablesCount((Entity)serverPlayer) >= 4) && currentCount >= this.targetCount;
        }
    }
}

