/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryHandler {
    public static final Set<String> SINGLE_IDENTIFIER = Collections.singleton("");
    private final Supplier<Set<String>> identifiersGetter;
    private final SlotCountGetter slotCountGetter;
    private final SlotStackGetter slotStackGetter;
    private final SlotStackSetter slotStackSetter;

    public PlayerInventoryHandler(Supplier<Set<String>> identifiersGetter, SlotCountGetter slotCountGetter, SlotStackGetter slotStackGetter, SlotStackSetter slotStackSetter) {
        this.identifiersGetter = identifiersGetter;
        this.slotCountGetter = slotCountGetter;
        this.slotStackGetter = slotStackGetter;
        this.slotStackSetter = slotStackSetter;
    }

    public int getSlotCount(Player player, String identifier) {
        return this.slotCountGetter.getSlotCount(player, identifier);
    }

    public ItemStack getStackInSlot(Player player, String identifier, int slot) {
        return this.slotStackGetter.getStackInSlot(player, identifier, slot);
    }

    public Set<String> getIdentifiers() {
        return this.identifiersGetter.get();
    }

    public void setStackInSlot(Player player, String identifier, int slot, ItemStack stack) {
        this.slotStackSetter.setStackInSlot(player, identifier, slot, stack);
    }

    public static interface SlotCountGetter {
        public int getSlotCount(Player var1, String var2);
    }

    public static interface SlotStackGetter {
        public ItemStack getStackInSlot(Player var1, String var2, int var3);
    }

    public static interface SlotStackSetter {
        public void setStackInSlot(Player var1, String var2, int var3, ItemStack var4);
    }
}

