/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item.util.fluid;

import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import reliquary.init.ModItems;
import reliquary.reference.Config;

public class FluidHandlerInfernalChalice
extends FluidHandlerItemStack {
    public FluidHandlerInfernalChalice(Supplier<DataComponentType<SimpleFluidContent>> componentType, ItemStack chalice) {
        super(componentType, chalice, ((Integer)Config.COMMON.items.infernalChalice.fluidLimit.get()).intValue());
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return !ModItems.INFERNAL_CHALICE.get().isEnabled(this.container) && fluid.getFluid().is(FluidTags.LAVA) && this.getFluid().getAmount() >= fluid.getAmount();
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return ModItems.INFERNAL_CHALICE.get().isEnabled(this.container) && fluid.getFluid() == Fluids.LAVA;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return stack.getFluid() == Fluids.LAVA;
    }
}

