/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import reliquary.init.ModItems;
import reliquary.item.MobCharmFragmentItem;

public class MobCharmDefinition {
    static final MobCharmDefinition ZOMBIE = new MobCharmDefinition(EntityType.ZOMBIE, ModItems.ZOMBIE_HEART.get(), EntityType.HUSK, EntityType.DROWNED, EntityType.ZOMBIE_VILLAGER);
    static final MobCharmDefinition SKELETON = new MobCharmDefinition(EntityType.SKELETON, ModItems.RIB_BONE.get(), EntityType.STRAY);
    static final MobCharmDefinition WITHER_SKELETON = new MobCharmDefinition(EntityType.WITHER_SKELETON, ModItems.WITHERED_RIB.get(), new EntityType[0]);
    static final MobCharmDefinition CREEPER = new MobCharmDefinition(EntityType.CREEPER, ModItems.CATALYZING_GLAND.get(), new EntityType[0]);
    static final MobCharmDefinition WITCH = new MobCharmDefinition(EntityType.WITCH, (Item)ModItems.WITCH_HAT.get(), new EntityType[0]);
    static final MobCharmDefinition ZOMBIFIED_PIGLIN = new MobCharmDefinition(EntityType.ZOMBIFIED_PIGLIN, ModItems.ZOMBIE_HEART.get(), new EntityType[0]);
    static final MobCharmDefinition CAVE_SPIDER = new MobCharmDefinition(EntityType.CAVE_SPIDER, ModItems.CHELICERAE.get(), new EntityType[0]);
    static final MobCharmDefinition SPIDER = new MobCharmDefinition(EntityType.SPIDER, ModItems.CHELICERAE.get(), new EntityType[0]);
    static final MobCharmDefinition ENDERMAN = new MobCharmDefinition(EntityType.ENDERMAN, ModItems.NEBULOUS_HEART.get(), new EntityType[0]);
    static final MobCharmDefinition GHAST = new MobCharmDefinition(EntityType.GHAST, ModItems.CATALYZING_GLAND.get(), new EntityType[0]);
    static final MobCharmDefinition SLIME = new MobCharmDefinition(EntityType.SLIME, ModItems.SLIME_PEARL.get(), new EntityType[0]);
    static final MobCharmDefinition MAGMA_CUBE = new MobCharmDefinition(EntityType.MAGMA_CUBE, ModItems.MOLTEN_CORE.get(), new EntityType[0]);
    static final MobCharmDefinition BLAZE = new MobCharmDefinition(EntityType.BLAZE, ModItems.MOLTEN_CORE.get(), new EntityType[0]);
    static final MobCharmDefinition GUARDIAN = new MobCharmDefinition(EntityType.GUARDIAN, ModItems.GUARDIAN_SPIKE.get(), new EntityType[0]);
    private final Set<ResourceLocation> applicableToEntities = new HashSet<ResourceLocation>();
    private final ResourceLocation registryName;
    private final Item repairItem;
    private boolean dynamicallyCreated = false;

    public MobCharmDefinition(EntityType<?> entityType) {
        this(entityType, null, entityType);
        this.dynamicallyCreated = true;
    }

    public MobCharmDefinition(EntityType<?> mainEntityType, @Nullable Item repairItem, EntityType<?> ... additionalApplicableTo) {
        this.registryName = EntityType.getKey(mainEntityType);
        this.repairItem = repairItem;
        this.applicableToEntities.add(this.registryName);
        Arrays.stream(additionalApplicableTo).map(EntityType::getKey).forEach(this.applicableToEntities::add);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Set<ResourceLocation> getEntities() {
        return this.applicableToEntities;
    }

    public boolean isRepairItem(ItemStack item) {
        return this.repairItem != null ? item.getItem() == this.repairItem : item.getItem() == ModItems.MOB_CHARM_FRAGMENT.get() && this.applicableToEntities.contains(MobCharmFragmentItem.getEntityRegistryName(item));
    }

    public boolean isDynamicallyCreated() {
        return this.dynamicallyCreated;
    }
}

