/*
 * Decompiled with CFR 0.152.
 */
package reliquary.init;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import reliquary.compat.botania.BotaniaCompat;
import reliquary.compat.curios.CuriosCompat;
import reliquary.compat.tconstruct.TConstructCompat;
import reliquary.util.LogHelper;

public class ModCompat {
    private static final Map<String, Supplier<Consumer<IEventBus>>> compatFactories = new HashMap<String, Supplier<Consumer<IEventBus>>>();

    private ModCompat() {
    }

    public static void initCompats(IEventBus modBus) {
        for (Map.Entry<String, Supplier<Consumer<IEventBus>>> entry : compatFactories.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            try {
                entry.getValue().get().accept(modBus);
            }
            catch (Exception e) {
                LogHelper.error("Error instantiating compatibility ", e);
            }
        }
    }

    static {
        compatFactories.put("curios", () -> CuriosCompat::new);
        compatFactories.put("botania", () -> BotaniaCompat::new);
        compatFactories.put("tconstruct", () -> TConstructCompat::new);
    }
}

