/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.magazines;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModItems;
import reliquary.item.BulletItem;
import reliquary.reference.Config;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class MagazineRecipeMaker {
    private MagazineRecipeMaker() {
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        MagazineRecipeMaker.addRegularMagazines(recipes);
        if (Boolean.FALSE.equals(Config.COMMON.disable.disablePotions.get())) {
            MagazineRecipeMaker.addPotionMagazines(recipes);
        }
        return recipes;
    }

    private static void addRegularMagazines(List<RecipeHolder<CraftingRecipe>> recipes) {
        ImmutableMap bulletMagazines = new ImmutableMap.Builder().put((Object)ModItems.NEUTRAL_BULLET.get(), (Object)ModItems.NEUTRAL_MAGAZINE.get()).put((Object)ModItems.EXORCISM_BULLET.get(), (Object)ModItems.EXORCISM_MAGAZINE.get()).put((Object)ModItems.BLAZE_BULLET.get(), (Object)ModItems.BLAZE_MAGAZINE.get()).put((Object)ModItems.ENDER_BULLET.get(), (Object)ModItems.ENDER_MAGAZINE.get()).put((Object)ModItems.CONCUSSIVE_BULLET.get(), (Object)ModItems.CONCUSSIVE_MAGAZINE.get()).put((Object)ModItems.BUSTER_BULLET.get(), (Object)ModItems.BUSTER_MAGAZINE.get()).put((Object)ModItems.SEEKER_BULLET.get(), (Object)ModItems.SEEKER_MAGAZINE.get()).put((Object)ModItems.SAND_BULLET.get(), (Object)ModItems.SAND_MAGAZINE.get()).put((Object)ModItems.STORM_BULLET.get(), (Object)ModItems.STORM_MAGAZINE.get()).build();
        for (Map.Entry bulletMagazine : bulletMagazines.entrySet()) {
            NonNullList inputs = NonNullList.create();
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, (BulletItem)bulletMagazine.getKey());
            inputs.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.EMPTY_MAGAZINE.get())}));
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, (BulletItem)bulletMagazine.getKey());
            ItemStack output = new ItemStack((ItemLike)bulletMagazine.getValue());
            ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(RegistryHelper.getRegistryName(output.getItem()), (Recipe)new ShapedRecipe("reliquary.magazine", CraftingBookCategory.MISC, pattern, output)));
        }
    }

    private static void addPotionMagazines(List<RecipeHolder<CraftingRecipe>> recipes) {
        for (PotionEssence essence : PotionMap.uniquePotions) {
            PotionContents potionContents = PotionHelper.changePotionEffectsDuration(essence.getPotionContents(), 0.2f);
            NonNullList inputs = NonNullList.create();
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, potionContents);
            inputs.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.EMPTY_MAGAZINE.get())}));
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, potionContents);
            ItemStack output = new ItemStack((ItemLike)ModItems.NEUTRAL_MAGAZINE.get());
            PotionHelper.addPotionContentsToStack(output, potionContents);
            ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(RegistryHelper.getRegistryName(output.getItem()), (Recipe)new ShapedRecipe("reliquary.potion.magazine", CraftingBookCategory.MISC, pattern, output)));
        }
    }

    private static void addShots(List<Ingredient> inputs, PotionContents potionContents) {
        MagazineRecipeMaker.addShots(inputs, potionContents, ModItems.NEUTRAL_BULLET.get());
    }

    private static void addShots(List<Ingredient> inputs, BulletItem shotType) {
        MagazineRecipeMaker.addShots(inputs, PotionContents.EMPTY, shotType);
    }

    private static void addShots(List<Ingredient> inputs, PotionContents potionContents, BulletItem shotType) {
        ItemStack shot = new ItemStack((ItemLike)shotType);
        if (potionContents.hasEffects()) {
            PotionHelper.addPotionContentsToStack(shot, potionContents);
        }
        for (int i = 0; i < 4; ++i) {
            inputs.add(Ingredient.of((ItemStack[])new ItemStack[]{shot}));
        }
    }
}

