/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import reliquary.item.VoidTearItem;

public class VoidTearModel
implements BakedModel {
    private final BakedModel originalModel;

    public VoidTearModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.originalModel.getQuads(state, side, rand);
    }

    public boolean useAmbientOcclusion() {
        return this.originalModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.originalModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.originalModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.originalModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.originalModel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.originalModel.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return new ItemOverrides(){

            public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
                BakedModel bakedModel;
                ItemStack containedStack;
                if (Screen.hasShiftDown() && !(containedStack = VoidTearItem.getTearContents(stack)).isEmpty() && !(bakedModel = Minecraft.getInstance().getItemRenderer().getModel(containedStack, (Level)level, entity, seed)).isCustomRenderer()) {
                    return bakedModel;
                }
                return VoidTearModel.this.originalModel.getOverrides().resolve(model, stack, level, entity, seed);
            }
        };
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.originalModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }
}

