/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.registry;

import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.DyenamicsAndFriends;
import cy.jdkdigital.dyenamicsandfriends.compat.AnotherFurnitureCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.BotanyPotsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.BumblezoneCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ChromaCarvingsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ClayworksCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ComfortsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ConnectedGlassCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.CookingForBlockheadsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.CreateCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ElevatoridCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.FurnishCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.JustBlahajCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.LuminaxCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ProductiveBeesCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ProductiveMetalworksCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.RegionsUnexploredCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.SophisticatedBackpacksCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DyenamicRegistry {
    public static final List<String> MODS = new ArrayList<String>(){
        {
            this.add("another_furniture");
            this.add("productivebees");
            this.add("productivemetalworks");
            this.add("connectedglass");
            this.add("comforts");
            this.add("elevatorid");
            this.add("furnish");
            this.add("regions_unexplored");
            this.add("sleep_tight");
            this.add("sophisticatedbackpacks");
            this.add("create");
            this.add("the_bumblezone");
            this.add("luminax");
            this.add("cookingforblockheads");
            this.add("clayworks");
            this.add("botanypots");
            this.add("just_blahaj");
            this.add("chromacarvings");
        }
    };

    public static void setup() {
    }

    public static void registerCompatModules() {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            if (ModList.get().isLoaded("create")) {
                CreateCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("createdeco")) {
                // empty if block
            }
            if (ModList.get().isLoaded("another_furniture")) {
                AnotherFurnitureCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("botanypots")) {
                BotanyPotsCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("comforts")) {
                ComfortsCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("elevatorid")) {
                ElevatoridCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("productivebees")) {
                ProductiveBeesCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("productivemetalworks")) {
                ProductiveMetalworksCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("farmersdelight")) {
                // empty if block
            }
            if (ModList.get().isLoaded("reliquary")) {
                // empty if block
            }
            if (ModList.get().isLoaded("snowyspirit")) {
                // empty if block
            }
            if (ModList.get().isLoaded("supplementaries")) {
                // empty if block
            }
            if (ModList.get().isLoaded("suppsquared")) {
                // empty if block
            }
            if (ModList.get().isLoaded("regions_unexplored")) {
                RegionsUnexploredCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("waystones")) {
                // empty if block
            }
            if (ModList.get().isLoaded("quark")) {
                // empty if block
            }
            if (ModList.get().isLoaded("furnish")) {
                FurnishCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("skinnedlanterns")) {
                // empty if block
            }
            if (ModList.get().isLoaded("nightlights")) {
                // empty if block
            }
            if (ModList.get().isLoaded("cfm")) {
                // empty if block
            }
            if (ModList.get().isLoaded("chalk")) {
                // empty if block
            }
            if (ModList.get().isLoaded("oreganized")) {
                // empty if block
            }
            if (ModList.get().isLoaded("ceramics")) {
                // empty if block
            }
            if (ModList.get().isLoaded("glazedresymmetry")) {
                // empty if block
            }
            if (ModList.get().isLoaded("clayworks")) {
                ClayworksCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("the_bumblezone")) {
                BumblezoneCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("sleep_tight")) {
                // empty if block
            }
            if (ModList.get().isLoaded("connectedglass")) {
                ConnectedGlassCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("luminax")) {
                LuminaxCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("cookingforblockheads")) {
                CookingForBlockheadsCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("chromacarvings")) {
                ChromaCarvingsCompat.registerEntities(color);
                ChromaCarvingsCompat.registerBlocks(color);
            }
            if (!ModList.get().isLoaded("just_blahaj")) continue;
            JustBlahajCompat.registerBlocks(color);
        }
        if (ModList.get().isLoaded("luminax")) {
            LuminaxCompat.postRegister();
        }
        if (ModList.get().isLoaded("create")) {
            CreateCompat.postRegister();
        }
        if (ModList.get().isLoaded("sophisticatedbackpacks")) {
            SophisticatedBackpacksCompat.postRegister();
        }
    }

    public static void clientRegister() {
        if (ModList.get().isLoaded("cookingforblockheads")) {
            CookingForBlockheadsCompat.Client.register();
        }
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (ModList.get().isLoaded("chromacarvings")) {
            ChromaCarvingsCompat.Client.registerEntityRenderers(event);
        }
    }

    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (ModList.get().isLoaded("create")) {
            CreateCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("comforts")) {
            ComfortsCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            // empty if block
        }
        if (ModList.get().isLoaded("furnish")) {
            FurnishCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("ceramics")) {
            // empty if block
        }
        if (ModList.get().isLoaded("sleep_tight")) {
            // empty if block
        }
        if (ModList.get().isLoaded("supplementaries")) {
            // empty if block
        }
        if (ModList.get().isLoaded("connectedglass")) {
            ConnectedGlassCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("clayworks")) {
            ClayworksCompat.Client.registerBlockEntityRenderers(event);
        }
    }

    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        if (ModList.get().isLoaded("chalk")) {
            // empty if block
        }
        if (ModList.get().isLoaded("elevatorid")) {
            ElevatoridCompat.Client.registerBlockColors(event);
        }
        if (ModList.get().isLoaded("cookingforblockheads")) {
            CookingForBlockheadsCompat.Client.registerBlockColors(event);
        }
    }

    public static void registerBlockRendering(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("ceramics")) {
            // empty if block
        }
        if (ModList.get().isLoaded("supplementaries")) {
            // empty if block
        }
        if (ModList.get().isLoaded("suppsquared")) {
            // empty if block
        }
        if (ModList.get().isLoaded("chalk")) {
            // empty if block
        }
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        if (ModList.get().isLoaded("chalk")) {
            // empty if block
        }
        if (ModList.get().isLoaded("elevatorid")) {
            ElevatoridCompat.Client.bakeModel(event);
        }
    }

    public static void onEntityPlace(BlockEvent.EntityPlaceEvent event) {
        if (ModList.get().isLoaded("furnish")) {
            FurnishCompat.entityPlace(event);
        }
    }

    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (ModList.get().isLoaded("farmersdelight")) {
            // empty if block
        }
        if (ModList.get().isLoaded("create")) {
            CreateCompat.playerRightClick(event);
        }
        if (ModList.get().isLoaded("cookingforblockheads")) {
            CookingForBlockheadsCompat.playerRightClick(event);
        }
    }

    public static Block getDyenamicsBlock(DyenamicDyeColor color, String block) {
        return (Block)((DeferredHolder)((Map)BlockInit.DYED_BLOCKS.get(color.getSerializedName())).get(block)).get();
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
    }

    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        if (ModList.get().isLoaded("clayworks")) {
            ClayworksCompat.Client.registerClientExtensions(event);
        }
    }

    public static DeferredHolder<Block, ? extends Block> registerBlock(String name, Supplier<? extends Block> sup, boolean registerItem) {
        DeferredHolder block = DyenamicsAndFriends.BLOCKS.register(name, sup);
        if (registerItem) {
            DyenamicRegistry.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    public static DeferredHolder<Block, ? extends Block> registerBlock(String name, Supplier<? extends Block> sup, @Nullable Supplier<Item> itemSupplier) {
        DeferredHolder block = DyenamicsAndFriends.BLOCKS.register(name, sup);
        if (itemSupplier != null) {
            DyenamicRegistry.registerItem(name, itemSupplier);
        }
        return block;
    }

    public static DeferredHolder<Item, ? extends Item> registerItem(String name, @Nullable Supplier<Item> itemSupplier) {
        return DyenamicsAndFriends.ITEMS.register(name, itemSupplier);
    }

    public static <E extends BlockEntity, T extends BlockEntityType<E>> Supplier<T> registerBlockEntity(String id, Supplier<T> supplier) {
        return DyenamicsAndFriends.BLOCK_ENTITIES.register(id, supplier);
    }

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityType.BlockEntitySupplier<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.of(factory, (Block[])blocks).build(null);
    }

    public static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> createEntity(String name, EntityType.Builder<E> builder) {
        DeferredHolder entity = DyenamicsAndFriends.ENTITIES.register(name, () -> builder.build("dyenamicsandfriends:" + name));
        return entity;
    }
}

