/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.util;

import dev.technici4n.moderndynamics.util.ItemVariant;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DropHelper {
    public static void dropStacks(BlockEntity blockEntity, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            DropHelper.dropStack(blockEntity, stack);
        }
    }

    public static void dropStack(BlockEntity blockEntity, ItemStack stack) {
        BlockPos pos = blockEntity.getBlockPos();
        Containers.dropItemStack((Level)blockEntity.getLevel(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
    }

    public static void dropStack(BlockEntity blockEntity, ItemVariant variant, long amount) {
        DropHelper.splitIntoStacks(variant, amount, stack -> DropHelper.dropStack(blockEntity, stack));
    }

    public static void splitIntoStacks(ItemVariant variant, long amount, Consumer<ItemStack> stackConsumer) {
        while (amount > 0L) {
            int dropped = (int)Math.min(amount, (long)variant.getMaxStackSize());
            stackConsumer.accept(variant.toStack(dropped));
            amount -= (long)dropped;
        }
    }
}

