/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.pipe;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.MdBlockEntity;
import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.model.AttachmentModelData;
import dev.technici4n.moderndynamics.model.PipeModelData;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.TickHelper;
import dev.technici4n.moderndynamics.pipe.PipeBoundingBoxes;
import dev.technici4n.moderndynamics.util.DropHelper;
import dev.technici4n.moderndynamics.util.ExtendedMenuProvider;
import dev.technici4n.moderndynamics.util.ShapeHelper;
import dev.technici4n.moderndynamics.util.WrenchHelper;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PipeBlockEntity
extends MdBlockEntity {
    private NodeHost[] hosts;
    private boolean hostsRegistered = false;
    public int connectionBlacklist = 0;
    private VoxelShape cachedShape = PipeBoundingBoxes.CORE_SHAPE;
    private ModelData clientModelData = ModelData.EMPTY;
    private int clientSideConnections = 0;

    public PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected abstract NodeHost[] createHosts();

    public final NodeHost[] getHosts() {
        if (this.hosts == null) {
            this.hosts = this.createHosts();
        }
        return this.hosts;
    }

    @Nullable
    public final <T> T findHost(Class<T> hostClass) {
        for (NodeHost host : this.getHosts()) {
            if (!hostClass.isInstance(host)) continue;
            return hostClass.cast(host);
        }
        return null;
    }

    private boolean hasAttachment(Direction side) {
        if (this.isClientSide()) {
            PipeModelData pipeData = this.getPipeModelData();
            return pipeData != null && pipeData.attachments()[side.get3DDataValue()] != null;
        }
        return this.getAttachment(side) != null;
    }

    @Nullable
    private PipeModelData getPipeModelData() {
        return (PipeModelData)this.clientModelData.get(PipeModelData.PIPE_DATA);
    }

    public final AttachedAttachment getAttachment(Direction side) {
        Preconditions.checkState((!this.isClientSide() ? 1 : 0) != 0, (Object)"Attachments don't exist on the client.");
        for (NodeHost host : this.getHosts()) {
            AttachedAttachment attachment = host.getAttachment(side);
            if (attachment == null) continue;
            return attachment;
        }
        return null;
    }

    @Nullable
    public Item getAttachmentItem(Direction side) {
        if (this.isClientSide()) {
            PipeModelData pipeModelData = this.getPipeModelData();
            if (pipeModelData != null) {
                AttachmentModelData attachment = pipeModelData.attachments()[side.get3DDataValue()];
                return attachment == null ? null : attachment.item();
            }
            return null;
        }
        AttachedAttachment attachment = this.getAttachment(side);
        return attachment == null ? null : attachment.getItem();
    }

    @Override
    public void sync() {
        super.sync();
        this.updateCachedShape(this.getPipeConnections(), this.getInventoryConnections());
    }

    @Override
    public void toClientTag(CompoundTag tag, RegistryAccess registries) {
        tag.putByte("connectionBlacklist", (byte)this.connectionBlacklist);
        tag.putByte("connections", (byte)this.getPipeConnections());
        tag.putByte("inventoryConnections", (byte)this.getInventoryConnections());
        for (NodeHost host : this.getHosts()) {
            host.writeClientNbt(tag, registries);
        }
        ListTag attachments = new ListTag();
        for (Direction direction : Direction.values()) {
            AttachedAttachment attachment = this.getAttachment(direction);
            if (attachment != null) {
                attachments.add((Object)attachment.getModelData().write(new CompoundTag()));
                continue;
            }
            attachments.add((Object)new CompoundTag());
        }
        tag.put("attachments", (Tag)attachments);
    }

    @Override
    public void fromClientTag(CompoundTag tag, RegistryAccess registries) {
        this.connectionBlacklist = tag.getByte("connectionBlacklist");
        byte connections = tag.getByte("connections");
        byte inventoryConnections = tag.getByte("inventoryConnections");
        NonNullList attachmentStacks = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)attachmentStacks, (HolderLookup.Provider)registries);
        for (NodeHost host : this.getHosts()) {
            host.readClientNbt(tag, registries);
        }
        if (tag.getBoolean("#c") || this.clientModelData == ModelData.EMPTY) {
            ListTag attachmentTags = tag.getList("attachments", 10);
            AttachmentModelData[] attachments = new AttachmentModelData[6];
            for (Direction direction : Direction.values()) {
                CompoundTag attachmentTag = attachmentTags.getCompound(direction.get3DDataValue());
                attachments[direction.get3DDataValue()] = AttachmentModelData.from(attachmentTag);
            }
            this.clientModelData = ModelData.builder().with(PipeModelData.PIPE_DATA, (Object)new PipeModelData(connections, inventoryConnections, attachments)).build();
            this.clientSideConnections = connections | inventoryConnections;
            this.requestModelDataUpdate();
            this.updateCachedShape(connections, inventoryConnections);
        }
    }

    @NotNull
    public ModelData getModelData() {
        return this.clientModelData;
    }

    @Override
    public void toTag(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putByte("connectionBlacklist", (byte)this.connectionBlacklist);
        if (!this.level.isClientSide()) {
            for (NodeHost host : this.getHosts()) {
                if (this.hostsRegistered) {
                    host.separateNetwork();
                }
                host.writeNbt(nbt, registries);
            }
        }
    }

    @Override
    public void fromTag(CompoundTag nbt, HolderLookup.Provider registries) {
        this.connectionBlacklist = nbt.getByte("connectionBlacklist");
        for (NodeHost host : this.getHosts()) {
            if (this.hostsRegistered) {
                host.separateNetwork();
            }
            host.readNbt(nbt, registries);
        }
    }

    public void scheduleHostUpdates() {
        for (NodeHost host : this.getHosts()) {
            host.scheduleUpdate();
        }
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (!this.level.isClientSide() && !this.hostsRegistered) {
            TickHelper.runLater(() -> {
                if (!this.hostsRegistered && !this.isRemoved()) {
                    this.hostsRegistered = true;
                    for (NodeHost host : this.getHosts()) {
                        host.addSelf();
                    }
                }
            });
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide() && this.hostsRegistered) {
            this.hostsRegistered = false;
            for (NodeHost host : this.getHosts()) {
                host.removeSelf();
            }
        }
    }

    public void refreshHosts() {
        if (this.hostsRegistered) {
            for (NodeHost host : this.getHosts()) {
                host.refreshSelf();
            }
        }
    }

    @Nullable
    public Object getApiInstance(BlockCapability<?, Direction> capability, @Nullable Direction side) {
        for (NodeHost host : this.getHosts()) {
            Object api = host.getApiInstance(capability, side);
            if (api == null) continue;
            return api;
        }
        return null;
    }

    protected int getPipeConnections() {
        int pipeConnections = 0;
        for (NodeHost host : this.getHosts()) {
            pipeConnections |= host.pipeConnections;
        }
        return pipeConnections;
    }

    protected int getInventoryConnections() {
        int inventoryConnections = 0;
        for (NodeHost host : this.getHosts()) {
            inventoryConnections |= host.inventoryConnections;
        }
        return inventoryConnections;
    }

    public VoxelShape getCachedShape() {
        return this.cachedShape;
    }

    public void updateCachedShape(int pipeConnections, int inventoryConnections) {
        int attachments = 0;
        for (Direction direction : Direction.values()) {
            if (!this.hasAttachment(direction)) continue;
            attachments |= 1 << direction.get3DDataValue();
        }
        this.cachedShape = PipeBoundingBoxes.getPipeShape(pipeConnections, inventoryConnections, attachments);
    }

    private void updateConnectionBlacklist(Direction side, boolean addConnection) {
        if (this.level.isClientSide()) {
            throw new IllegalStateException("updateConnections() should not be called client-side.");
        }
        this.connectionBlacklist = addConnection ? (this.connectionBlacklist &= ~(1 << side.get3DDataValue())) : (this.connectionBlacklist |= 1 << side.get3DDataValue());
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.relative(side));
        if (be instanceof PipeBlockEntity) {
            PipeBlockEntity neighborPipe = (PipeBlockEntity)be;
            neighborPipe.connectionBlacklist = addConnection ? (neighborPipe.connectionBlacklist &= ~(1 << side.getOpposite().get3DDataValue())) : (neighborPipe.connectionBlacklist |= 1 << side.getOpposite().get3DDataValue());
            neighborPipe.setChanged();
        }
    }

    protected void updateConnection(Direction side, boolean addConnection) {
        this.updateConnectionBlacklist(side, addConnection);
        this.refreshHosts();
        this.scheduleHostUpdates();
        this.invalidateCapabilities();
        this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
        this.setChanged();
    }

    public ItemInteractionResult useItemOn(Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item side;
        ItemStack stack = player.getItemInHand(hand);
        Vec3 posInBlock = this.getPosInBlock((HitResult)hitResult);
        if (WrenchHelper.isWrench(stack)) {
            if (ShapeHelper.shapeContains(PipeBoundingBoxes.CORE_SHAPE, posInBlock) && (this.connectionBlacklist & 1 << hitResult.getDirection().get3DDataValue()) > 0) {
                if (!this.level.isClientSide()) {
                    this.updateConnection(hitResult.getDirection(), true);
                }
                return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide());
            }
            for (int i = 0; i < 6; ++i) {
                if (!ShapeHelper.shapeContains(PipeBoundingBoxes.INVENTORY_CONNECTIONS[i], posInBlock)) continue;
                side = Direction.from3DDataValue((int)i);
                if (this.hasAttachment((Direction)side)) {
                    if (this.isClientSide()) {
                        return ItemInteractionResult.SUCCESS;
                    }
                    for (NodeHost host : this.getHosts()) {
                        AttachedAttachment attachment = host.getAttachment((Direction)side);
                        if (attachment == null) continue;
                        if (attachment.tryClearContents(this)) {
                            return ItemInteractionResult.CONSUME;
                        }
                        host.removeAttachment((Direction)side);
                        if (!player.isCreative()) {
                            DropHelper.dropStacks(this, attachment.getDrops());
                        }
                        this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
                        this.refreshHosts();
                        this.scheduleHostUpdates();
                        this.setChanged();
                        this.sync();
                        return ItemInteractionResult.CONSUME;
                    }
                    continue;
                }
                if (this.level.isClientSide()) {
                    if ((this.clientSideConnections & 1 << i) <= 0) continue;
                    return ItemInteractionResult.SUCCESS;
                }
                if ((this.getPipeConnections() & 1 << i) <= 0 && (this.getInventoryConnections() & 1 << i) <= 0) continue;
                this.updateConnection(Direction.from3DDataValue((int)i), false);
                return ItemInteractionResult.CONSUME;
            }
        }
        if ((side = stack.getItem()) instanceof AttachmentItem) {
            AttachmentItem attachmentItem = (AttachmentItem)side;
            Direction hitSide = null;
            if (ShapeHelper.shapeContains(PipeBoundingBoxes.CORE_SHAPE, posInBlock)) {
                hitSide = hitResult.getDirection();
            }
            for (int i = 0; i < 6; ++i) {
                if (!ShapeHelper.shapeContains(PipeBoundingBoxes.INVENTORY_CONNECTIONS[i], posInBlock)) continue;
                hitSide = Direction.from3DDataValue((int)i);
            }
            if (hitSide != null && !this.hasAttachment(hitSide)) {
                for (NodeHost host : this.getHosts()) {
                    if (!host.acceptsAttachment(attachmentItem, stack)) continue;
                    if (!this.level.isClientSide) {
                        this.updateConnectionBlacklist(hitSide, true);
                        host.setAttachment(hitSide, attachmentItem, new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess());
                        host.getAttachment(hitSide).onPlaced(player);
                        this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
                        this.refreshHosts();
                        this.scheduleHostUpdates();
                        this.setChanged();
                        this.sync();
                    }
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(Player player, BlockHitResult hitResult) {
        Vec3 posInBlock = this.getPosInBlock((HitResult)hitResult);
        Direction hitSide = this.hitTestAttachments(posInBlock);
        if (hitSide != null) {
            ExtendedMenuProvider menuProvider;
            AttachedAttachment attachment;
            if (!this.isClientSide() && (attachment = this.getAttachment(hitSide)) != null && attachment.hasMenu() && (menuProvider = attachment.createMenu(this, hitSide)) != null) {
                player.openMenu((MenuProvider)menuProvider, menuProvider::writeScreenOpeningData);
            }
            return InteractionResult.sidedSuccess((boolean)this.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public Vec3 getPosInBlock(HitResult hitResult) {
        return hitResult.getLocation().subtract((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
    }

    @Nullable
    public Direction hitTestAttachments(Vec3 posInBlock) {
        for (int i = 0; i < 6; ++i) {
            Direction direction = Direction.from3DDataValue((int)i);
            if (!this.hasAttachment(direction) || !ShapeHelper.shapeContains(PipeBoundingBoxes.CONNECTOR_SHAPES[i], posInBlock)) continue;
            return direction;
        }
        return null;
    }

    public ItemStack overridePickBlock(HitResult hitResult) {
        Direction side = this.hitTestAttachments(this.getPosInBlock(hitResult));
        if (side != null) {
            return Objects.requireNonNull(this.getAttachmentItem(side), "Failed to get attachment item").getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    public void onRemoved() {
        for (NodeHost host : this.getHosts()) {
            host.onRemoved();
        }
    }

    public int getClientSideConnections() {
        Preconditions.checkState((boolean)this.isClientSide());
        return this.clientSideConnections;
    }

    public void clientTick() {
        for (NodeHost host : this.getHosts()) {
            host.clientTick();
        }
    }
}

