/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.mienergy;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.energy.EnergyCache;
import dev.technici4n.moderndynamics.network.mienergy.MICableTier;
import dev.technici4n.moderndynamics.network.mienergy.MIEnergyHost;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class MIEnergyCache
extends NetworkCache<MIEnergyHost, MIEnergyCache> {
    private long energy = 0L;
    private long maxEnergy = 0L;

    protected MIEnergyCache(ServerLevel level, List<NetworkNode<MIEnergyHost, MIEnergyCache>> networkNodes) {
        super(level, networkNodes);
    }

    @Override
    protected void doCombine() {
        this.maxEnergy = 0L;
        this.energy = 0L;
        for (NetworkNode node : this.nodes) {
            this.energy = MIEnergyCache.saturatedSum(this.energy, ((MIEnergyHost)node.getHost()).getEnergy());
            this.maxEnergy = MIEnergyCache.saturatedSum(this.maxEnergy, ((MIEnergyHost)node.getHost()).getMaxEnergy());
        }
    }

    @Override
    protected void doSeparate() {
        int remainingNodes = this.nodes.size();
        for (NetworkNode node : this.nodes) {
            MIEnergyHost host = (MIEnergyHost)node.getHost();
            long nodeEnergy = Math.min(host.getMaxEnergy(), this.energy / (long)remainingNodes);
            host.setEnergy(nodeEnergy);
            this.energy -= nodeEnergy;
            --remainingNodes;
        }
    }

    @Override
    protected void doTick() {
        this.combine();
        ArrayList<IEnergyStorage> storages = new ArrayList<IEnergyStorage>();
        for (NetworkNode node : this.nodes) {
            if (!((MIEnergyHost)node.getHost()).isTicking()) continue;
            ((MIEnergyHost)node.getHost()).gatherCapabilities(storages);
        }
        MICableTier tier = ((MIEnergyHost)((NetworkNode)this.nodes.get((int)0)).getHost()).tier;
        this.energy += (long)EnergyCache.transferForTargets(IEnergyStorage::extractEnergy, storages, (int)Math.min(this.maxEnergy - this.energy, (long)tier.getMax()));
        this.energy -= (long)EnergyCache.transferForTargets(IEnergyStorage::receiveEnergy, storages, (int)Math.min(this.energy, (long)tier.getMax()));
    }

    private static long saturatedSum(long a, long b) {
        Preconditions.checkArgument((a >= 0L ? 1 : 0) != 0, (Object)"a >= 0");
        Preconditions.checkArgument((b >= 0L ? 1 : 0) != 0, (Object)"b >= 0");
        long sum = a + b;
        if (sum < a || sum < b) {
            return Long.MAX_VALUE;
        }
        return sum;
    }
}

