/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.fluid;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.AttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.network.HostAdjacentCaps;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.fluid.ConnectedFluidStorage;
import dev.technici4n.moderndynamics.network.fluid.FilteringFluidHandler;
import dev.technici4n.moderndynamics.network.fluid.FluidCache;
import dev.technici4n.moderndynamics.network.shared.TransferLimits;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.FluidVariant;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidHost
extends NodeHost {
    private static final NetworkManager<FluidHost, FluidCache> MANAGER = NetworkManager.get(FluidCache.class, FluidCache::new);
    private FluidVariant variant = FluidVariant.blank();
    private int amount = 0;
    private final TransferLimits extractorLimit = new TransferLimits(side -> {
        FluidAttachedIo io;
        AttachedAttachment patt0$temp = this.getAttachment(side);
        if (!(patt0$temp instanceof FluidAttachedIo) || (io = (FluidAttachedIo)patt0$temp).getType() != IoAttachmentType.EXTRACTOR) {
            return 0;
        }
        return io.getFluidMaxIo();
    }, 1000);
    private final IFluidHandler[] caps = new IFluidHandler[6];
    private final IFluidHandler unsidedCap;
    private final HostAdjacentCaps<IFluidHandler> adjacentCaps = new HostAdjacentCaps(this, Capabilities.FluidHandler.BLOCK);

    public FluidHost(PipeBlockEntity pipe) {
        super(pipe);
        for (int i = 0; i < 6; ++i) {
            final Direction dir = Direction.from3DDataValue((int)i);
            this.caps[i] = new FilteringFluidHandler(this::getInternalNetworkStorage){

                @Override
                protected boolean canInsert(FluidVariant resource) {
                    return FluidHost.this.canMoveOutsideToNetwork(dir, resource);
                }

                @Override
                protected boolean canExtract(FluidVariant resource) {
                    return FluidHost.this.canMoveNetworkToOutside(dir, resource);
                }
            };
        }
        this.unsidedCap = new FilteringFluidHandler(this, this::getInternalNetworkStorage){

            @Override
            protected boolean canInsert(FluidVariant resource) {
                return false;
            }

            @Override
            protected boolean canExtract(FluidVariant resource) {
                return false;
            }
        };
    }

    @Override
    public NetworkManager<FluidHost, FluidCache> getManager() {
        return MANAGER;
    }

    @Override
    @Nullable
    public Object getApiInstance(BlockCapability<?, Direction> lookup, @Nullable Direction side) {
        if (lookup == Capabilities.FluidHandler.BLOCK) {
            if (side == null) {
                return this.unsidedCap;
            }
            if ((this.pipe.connectionBlacklist & 1 << side.get3DDataValue()) == 0) {
                return this.caps[side.get3DDataValue()];
            }
        }
        return null;
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidVariant getVariant() {
        return this.variant;
    }

    public void setContents(FluidVariant variant, int nodeFluid) {
        if (!variant.equals(this.variant) || nodeFluid != this.amount) {
            this.variant = variant;
            this.amount = nodeFluid;
            this.pipe.setChanged();
            this.pipe.sync(false);
        }
    }

    @Override
    protected void doUpdate() {
        this.updateConnections();
    }

    @Override
    public boolean acceptsAttachment(AttachmentItem attachment, ItemStack stack) {
        return attachment instanceof IoAttachmentItem;
    }

    @Override
    public boolean canConnectTo(Direction connectionDirection, NodeHost adjacentHost) {
        AttachedAttachment attachment = this.getAttachment(connectionDirection);
        if (attachment instanceof AttachedIo) {
            return false;
        }
        return super.canConnectTo(connectionDirection, adjacentHost) && this.hasCompatibleFluid(adjacentHost);
    }

    private boolean hasCompatibleFluid(NodeHost other) {
        return FluidCache.areCompatible(((FluidHost)other).variant, this.variant);
    }

    @Override
    public void onConnectedTo(NodeHost other) {
        if (other instanceof FluidHost) {
            FluidHost fh = (FluidHost)other;
            if (!fh.variant.isBlank()) {
                this.variant = fh.variant;
                this.pipe.setChanged();
            }
        }
    }

    @Override
    public void onConnectionRejectedTo(Direction direction, NodeHost other) {
        if (this.getAttachment(direction) instanceof AttachedIo || other.getAttachment(direction.getOpposite()) instanceof AttachedIo) {
            return;
        }
        if (!this.hasCompatibleFluid(other)) {
            this.pipe.connectionBlacklist |= 1 << direction.get3DDataValue();
            this.pipe.setChanged();
        }
    }

    public void gatherCapabilities(@Nullable List<ConnectedFluidStorage> out) {
        int oldConnections = this.inventoryConnections;
        for (int i = 0; i < 6; ++i) {
            if ((this.inventoryConnections & 1 << i) <= 0 || (this.pipeConnections & 1 << i) != 0) continue;
            final Direction dir = Direction.from3DDataValue((int)i);
            IFluidHandler adjacentCap = this.adjacentCaps.getCapability(dir);
            if (adjacentCap != null) {
                FluidAttachedIo io;
                FluidAttachedIo attachment;
                if (out == null) continue;
                AttachedAttachment attachedAttachment = this.getAttachment(dir);
                FluidAttachedIo fluidAttachedIo = attachment = attachedAttachment instanceof FluidAttachedIo ? (io = (FluidAttachedIo)attachedAttachment) : null;
                if (attachment == null) {
                    out.add(new ConnectedFluidStorage(adjacentCap, null, null));
                    continue;
                }
                if (!attachment.isEnabledViaRedstone(this.pipe)) continue;
                FilteringFluidHandler filteredStorage = new FilteringFluidHandler(adjacentCap){

                    @Override
                    protected boolean canExtract(FluidVariant resource) {
                        return FluidHost.this.canMoveOutsideToNetwork(dir, resource);
                    }

                    @Override
                    protected boolean canInsert(FluidVariant resource) {
                        return FluidHost.this.canMoveNetworkToOutside(dir, resource);
                    }
                };
                ExtractorStorage extractorRateLimit = attachment.getType() == IoAttachmentType.EXTRACTOR ? new ExtractorStorage(filteredStorage, i) : null;
                out.add(new ConnectedFluidStorage(filteredStorage, attachment, extractorRateLimit));
                continue;
            }
            this.inventoryConnections ^= 1 << i;
        }
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    public void updateConnections() {
        int oldConnections = this.inventoryConnections;
        this.inventoryConnections = 63 - (this.pipeConnections | this.pipe.connectionBlacklist);
        this.gatherCapabilities(null);
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeNbt(tag, registries);
        tag.putInt("amount", this.amount);
        tag.put("variant", this.variant.toNbt(registries));
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.readNbt(tag, registries);
        this.variant = FluidVariant.fromNbt(tag.getCompound("variant"), registries);
        this.amount = Math.max(0, Math.min(tag.getInt("amount"), 1000));
        if (this.variant.isBlank()) {
            this.amount = 0;
        }
    }

    @Override
    public void writeClientNbt(CompoundTag tag, RegistryAccess registries) {
        super.writeClientNbt(tag, registries);
        tag.putInt("amount", this.amount);
        tag.put("variant", this.variant.toNbt((HolderLookup.Provider)registries));
    }

    @Override
    public void readClientNbt(CompoundTag tag, RegistryAccess registries) {
        super.readClientNbt(tag, registries);
        this.variant = FluidVariant.fromNbt(tag.getCompound("variant"), (HolderLookup.Provider)registries);
        this.amount = tag.getInt("amount");
    }

    private boolean canMoveNetworkToOutside(Direction side, FluidVariant variant) {
        AttachedAttachment attachedAttachment = this.getAttachment(side);
        if (attachedAttachment instanceof FluidAttachedIo) {
            FluidAttachedIo io = (FluidAttachedIo)attachedAttachment;
            return io.matchesFilter(variant) && io.isEnabledViaRedstone(this.pipe) && io.getType() != IoAttachmentType.EXTRACTOR;
        }
        return true;
    }

    private boolean canMoveOutsideToNetwork(Direction side, FluidVariant variant) {
        AttachedAttachment attachedAttachment = this.getAttachment(side);
        if (attachedAttachment instanceof FluidAttachedIo) {
            FluidAttachedIo io = (FluidAttachedIo)attachedAttachment;
            return io.matchesFilter(variant) && io.isEnabledViaRedstone(this.pipe) && io.getType() != IoAttachmentType.ATTRACTOR;
        }
        return true;
    }

    private IFluidHandler getInternalNetworkStorage() {
        NetworkNode node = this.findNode();
        if (node != null && node.getHost() == this) {
            return ((FluidCache)node.getNetworkCache()).getOrCreateStorage();
        }
        return EmptyFluidHandler.INSTANCE;
    }

    private class ExtractorStorage
    implements IFluidHandler {
        private final int directionId;
        private final IFluidHandler delegate;

        ExtractorStorage(IFluidHandler delegate, int directionId) {
            this.delegate = delegate;
            this.directionId = directionId;
        }

        public int getTanks() {
            return this.delegate.getTanks();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.delegate.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.delegate.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.delegate.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            throw new UnsupportedOperationException("Should not be used to insert, only to extract!");
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            int maxAmount = FluidHost.this.extractorLimit.limit(this.directionId, resource.getAmount());
            if (maxAmount <= 0) {
                return FluidStack.EMPTY;
            }
            if (maxAmount != resource.getAmount()) {
                resource = resource.copy();
                resource.setAmount(maxAmount);
            }
            FluidStack transferred = this.delegate.drain(resource, action);
            if (action.execute()) {
                FluidHost.this.extractorLimit.use(this.directionId, transferred.getAmount());
            }
            return transferred;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if ((maxDrain = FluidHost.this.extractorLimit.limit(this.directionId, maxDrain)) <= 0) {
                return FluidStack.EMPTY;
            }
            FluidStack transferred = this.delegate.drain(maxDrain, action);
            if (action.execute()) {
                FluidHost.this.extractorLimit.use(this.directionId, transferred.getAmount());
            }
            return transferred;
        }
    }

    private class SingleTank
    extends FluidTank {
        public SingleTank(FluidHost fluidHost, int capacity) {
            super(capacity);
        }
    }
}

