/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.data;

import com.google.common.hash.HashCode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.technici4n.moderndynamics.util.MdId;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;

public class EmptyTestStructureGenerator
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;

    public EmptyTestStructureGenerator(PackOutput output) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "structure");
    }

    public CompletableFuture<?> run(CachedOutput output) {
        CompoundTag structureTag;
        String structureIn;
        try (InputStream in = this.getClass().getResourceAsStream("/data/moderndynamics/structure/empty.snbt");){
            structureIn = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            structureTag = NbtUtils.snbtToStructure((String)structureIn);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            NbtIo.writeCompressed((CompoundTag)structureTag, (OutputStream)new DataOutputStream(out));
            output.writeIfNeeded(this.pathProvider.file(MdId.of("empty"), "nbt"), out.toByteArray(), HashCode.fromBytes((byte[])out.toByteArray()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return CompletableFuture.completedFuture(null);
    }

    public String getName() {
        return "Empty Test Structure";
    }
}

