/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.technici4n.moderndynamics.client.ber.FluidPipeRendering;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.fluid.FluidHost;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItem;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItemSmoothing;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;

public class PipeBlockEntityRenderer
implements BlockEntityRenderer<PipeBlockEntity> {
    private final BlockEntityRendererProvider.Context ctx;
    private final Random random = new Random();
    private static final Vec3 CENTER = new Vec3(0.5, 0.5, 0.5);

    public PipeBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.ctx = ctx;
    }

    public void render(PipeBlockEntity pipe, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        for (NodeHost host : pipe.getHosts()) {
            if (host instanceof ItemHost) {
                ItemHost itemHost = (ItemHost)host;
                for (ClientTravelingItem item : itemHost.getClientTravelingItems()) {
                    double ratio;
                    Vec3 to;
                    Vec3 from;
                    matrices.pushPose();
                    double distance = Mth.frac((double)item.traveledDistance()) + ClientTravelingItemSmoothing.getDistanceDelta(item, tickDelta) + item.speed() * (double)tickDelta;
                    if (distance <= 0.5) {
                        from = PipeBlockEntityRenderer.findFaceMiddle(item.in().getOpposite());
                        to = CENTER;
                        ratio = distance * 2.0;
                    } else {
                        from = CENTER;
                        to = PipeBlockEntityRenderer.findFaceMiddle(item.out());
                        ratio = (distance - 0.5) * 2.0;
                    }
                    matrices.translate(to.x() * ratio + from.x() * (1.0 - ratio), to.y() * ratio + from.y() * (1.0 - ratio), to.z() * ratio + from.z() * (1.0 - ratio));
                    matrices.scale(0.6f, 0.6f, 0.6f);
                    matrices.translate(0.0f, -0.15f, 0.0f);
                    int seed = item.variant().hashCode() + item.id;
                    this.random.setSeed(seed);
                    float rotAngle = (float)((double)((float)ClientTravelingItemSmoothing.getClientTick() + tickDelta) * item.speed() + (double)(this.random.nextFloat() * 2.0f) * Math.PI);
                    matrices.mulPose(Axis.YP.rotation(rotAngle));
                    int renderCount = PipeBlockEntityRenderer.getRenderAmount(item.amount());
                    matrices.translate(0.0, 0.0, (double)(-(renderCount - 1)) * 0.1 / 2.0);
                    for (int r = 0; r < renderCount; ++r) {
                        matrices.pushPose();
                        matrices.translate((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.02f), (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.02f), (double)r * 0.1);
                        Minecraft.getInstance().getItemRenderer().renderStatic(item.variant().toStack(), ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, pipe.getLevel(), 0);
                        matrices.popPose();
                    }
                    matrices.popPose();
                }
                continue;
            }
            if (!(host instanceof FluidHost)) continue;
            FluidHost fluidHost = (FluidHost)host;
            FluidPipeRendering.drawFluidInPipe(pipe, matrices, vertexConsumers, fluidHost.getVariant(), (float)fluidHost.getAmount() / 1000.0f);
        }
    }

    private static Vec3 findFaceMiddle(Direction face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new Vec3(0.5, 0.0, 0.5);
            case Direction.UP -> new Vec3(0.5, 1.0, 0.5);
            case Direction.NORTH -> new Vec3(0.5, 0.5, 0.0);
            case Direction.SOUTH -> new Vec3(0.5, 0.5, 1.0);
            case Direction.WEST -> new Vec3(0.0, 0.5, 0.5);
            case Direction.EAST -> new Vec3(1.0, 0.5, 0.5);
        };
    }

    private static int getRenderAmount(long amount) {
        int i = 1;
        if (amount > 48L) {
            i = 5;
        } else if (amount > 32L) {
            i = 4;
        } else if (amount > 16L) {
            i = 3;
        } else if (amount > 1L) {
            i = 2;
        }
        return i;
    }
}

