/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.attached;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.Setting;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.UpgradeContainer;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.RedstoneMode;
import dev.technici4n.moderndynamics.attachment.upgrade.LoadedUpgrades;
import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.WrenchHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AttachedIo
extends AttachedAttachment {
    public static final int UPGRADE_SLOTS = 4;
    protected final Runnable setChangedCallback;
    private FilterInversionMode filterInversion;
    private RedstoneMode redstoneMode;
    protected final UpgradeContainer upgradeContainer = new UpgradeContainer();

    public AttachedIo(AttachmentItem item, CompoundTag configData, Runnable setChangedCallback, HolderLookup.Provider registries) {
        super(item, configData);
        this.setChangedCallback = setChangedCallback;
        this.filterInversion = (FilterInversionMode)AttachedIo.readEnum((Enum[])FilterInversionMode.values(), (CompoundTag)configData, (String)"filterInversion", (Enum)FilterInversionMode.BLACKLIST);
        this.redstoneMode = (RedstoneMode)AttachedIo.readEnum((Enum[])RedstoneMode.values(), (CompoundTag)configData, (String)"redstoneMode", (Enum)RedstoneMode.IGNORED);
        this.upgradeContainer.readNbt(configData, registries);
    }

    @Override
    public CompoundTag writeConfigTag(CompoundTag configData, HolderLookup.Provider registries) {
        super.writeConfigTag(configData, registries);
        AttachedIo.writeEnum(this.filterInversion, configData, "filterInversion");
        AttachedIo.writeEnum(this.redstoneMode, configData, "redstoneMode");
        this.upgradeContainer.writeNbt(configData, registries);
        return configData;
    }

    public FilterInversionMode getFilterInversion() {
        return this.filterInversion;
    }

    public void setFilterInversion(FilterInversionMode filterInversion) {
        if (filterInversion != this.filterInversion) {
            this.filterInversion = filterInversion;
            this.resetCachedFilter();
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
    }

    public ItemStack getUpgrade(int slot) {
        return (ItemStack)this.upgradeContainer.upgrades.get(slot);
    }

    public void setUpgrade(int slot, ItemStack upgrade) {
        this.upgradeContainer.upgrades.set(slot, (Object)upgrade);
        this.onUpgradesChanged();
    }

    public ItemStack removeUpgrade(int slot, int count) {
        return ContainerHelper.removeItem(this.upgradeContainer.upgrades, (int)slot, (int)count);
    }

    public boolean mayPlaceUpgrade(int slot, Item upgrade) {
        if (!this.upgradeContainer.mayPlaceUpgrade(slot, upgrade)) {
            return false;
        }
        UpgradeType type = LoadedUpgrades.getType(upgrade);
        if (type.getAddFilterSlots() > 0) {
            return true;
        }
        if (this instanceof ItemAttachedIo) {
            if (type.isEnableAdvancedBehavior() || type.getAddItemSpeed() > 0) {
                return true;
            }
            if (this.getType() != IoAttachmentType.FILTER && (type.getAddItemCount() > 0 || type.getAddItemTransferFrequency() > 0)) {
                return true;
            }
        }
        return this instanceof FluidAttachedIo && (type.getAddFluidTransfer() > 0 || type.getMultiplyFluidTransfer() > 0);
    }

    public void onUpgradesChanged() {
        this.setChangedCallback.run();
        this.resetCachedFilter();
    }

    public int getFilterSize() {
        return this.upgradeContainer.getFilterSize();
    }

    protected abstract void resetCachedFilter();

    @Override
    public IoAttachmentItem getItem() {
        return (IoAttachmentItem)super.getItem();
    }

    public IoAttachmentType getType() {
        return this.getItem().getType();
    }

    public Set<Setting> getSupportedSettings() {
        return this.getItem().getSupportedSettings();
    }

    public boolean isAdvancedBehaviorAllowed() {
        return this.upgradeContainer.isAdvancedBehaviorAllowed();
    }

    protected static <T extends Enum<T>> T readEnum(T[] enumValues, CompoundTag tag, String key, T defaultValue) {
        byte idx = tag.getByte(key);
        if (!tag.contains(key) || idx < 0 || idx >= enumValues.length) {
            return defaultValue;
        }
        return enumValues[idx];
    }

    protected static <T extends Enum<T>> void writeEnum(T enumValue, CompoundTag tag, String key) {
        tag.putByte(key, (byte)enumValue.ordinal());
    }

    public boolean isEnabledViaRedstone(PipeBlockEntity pipe) {
        if (this.getRedstoneMode() == RedstoneMode.IGNORED) {
            return true;
        }
        boolean signal = pipe.getLevel().hasNeighborSignal(pipe.getBlockPos());
        if (signal) {
            return this.getRedstoneMode() == RedstoneMode.REQUIRES_HIGH;
        }
        return this.getRedstoneMode() == RedstoneMode.REQUIRES_LOW;
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.getDrops());
        for (ItemStack upgrade : this.upgradeContainer.upgrades) {
            if (upgrade.isEmpty()) continue;
            drops.add(upgrade);
        }
        return drops;
    }

    @Override
    public void onPlaced(Player player) {
        if (WrenchHelper.isWrench(player.getOffhandItem())) {
            this.filterInversion = FilterInversionMode.WHITELIST;
        }
    }
}

