/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RenderedAttachment {
    private static final Map<String, RenderedAttachment> REGISTERED_ATTACHMENTS = new HashMap<String, RenderedAttachment>();
    public final String id;

    public static List<String> getAttachmentIds() {
        return new ArrayList<String>(REGISTERED_ATTACHMENTS.keySet());
    }

    public static List<RenderedAttachment> getAllAttachments() {
        return new ArrayList<RenderedAttachment>(REGISTERED_ATTACHMENTS.values());
    }

    public RenderedAttachment(String id) {
        this.id = id;
        if (REGISTERED_ATTACHMENTS.put(id, this) != null) {
            throw new IllegalStateException("Duplicate attachment registration with id " + id);
        }
    }

    public RenderedAttachment getStuffed() {
        RenderedAttachment stuffed = REGISTERED_ATTACHMENTS.get(this.id + "_stuffed");
        Objects.requireNonNull(stuffed, "Could not find stuffed variant for attachment " + this.id);
        return stuffed;
    }
}

