/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.treetap.common.block.entity.SapCollectorBlockEntity;
import cy.jdkdigital.treetap.common.recipe.TapExtractRecipe;
import cy.jdkdigital.treetap.util.ColorUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class SapCollectorBlockEntityRenderer
implements BlockEntityRenderer<SapCollectorBlockEntity> {
    public SapCollectorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SapCollectorBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        if (blockEntity.progress > 0 && blockEntity.currentRecipe != null) {
            poseStack.pushPose();
            Minecraft minecraft = Minecraft.getInstance();
            float pixHeight = 0.0625f;
            FluidStack fluidStack = ((TapExtractRecipe)blockEntity.currentRecipe.value()).displayFluid;
            Fluid fluid = fluidStack.getFluid();
            int fluidBrightness = Math.max(combinedLightIn, fluid.getFluidType().getLightLevel());
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
            int fluidTintColour = ((TapExtractRecipe)blockEntity.currentRecipe.value()).fluidColor.isEmpty() ? renderProperties.getTintColor(fluidStack) : ColorUtil.getCacheColor(((TapExtractRecipe)blockEntity.currentRecipe.value()).fluidColor).intValue();
            float[] color = ColorUtil.getCacheColor(fluidTintColour);
            color[3] = color[3] == 0.0f ? 1.0f : color[3];
            TextureAtlasSprite stillFluidSprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(renderProperties.getStillTexture(fluidStack));
            VertexConsumer vertexBuffer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            Matrix4f lastPose = poseStack.last().pose();
            float progress = (float)blockEntity.progress / (float)((TapExtractRecipe)blockEntity.currentRecipe.value()).processingTime;
            float fluidY = (4.0f + 9.0f * progress) / 16.0f;
            Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
            float x1 = switch (dir) {
                case Direction.NORTH, Direction.SOUTH -> pixHeight * 13.5f;
                case Direction.EAST -> pixHeight * 10.0f;
                case Direction.WEST -> pixHeight * 15.0f;
                default -> 0.0f;
            };
            float x2 = switch (dir) {
                case Direction.NORTH, Direction.SOUTH -> pixHeight * 2.5f;
                case Direction.EAST -> pixHeight;
                case Direction.WEST -> pixHeight * 6.0f;
                default -> 0.0f;
            };
            float z1 = switch (dir) {
                case Direction.NORTH -> pixHeight * 15.0f;
                case Direction.SOUTH -> pixHeight * 10.0f;
                case Direction.EAST, Direction.WEST -> pixHeight * 13.5f;
                default -> 0.0f;
            };
            float z2 = switch (dir) {
                case Direction.NORTH -> pixHeight * 6.0f;
                case Direction.SOUTH -> pixHeight;
                case Direction.EAST, Direction.WEST -> pixHeight * 2.5f;
                default -> 0.0f;
            };
            float fluidSpriteU0 = stillFluidSprite.getU0() + (stillFluidSprite.getU1() - stillFluidSprite.getU0()) / 8.0f;
            float fluidSpriteU1 = stillFluidSprite.getU1() - (stillFluidSprite.getU1() - stillFluidSprite.getU0()) / 8.0f;
            float fluidSpriteV0 = stillFluidSprite.getV0() + (stillFluidSprite.getV1() - stillFluidSprite.getV0()) / 8.0f;
            float fluidSpriteV1 = stillFluidSprite.getV1() - (stillFluidSprite.getV1() - stillFluidSprite.getV0()) / 8.0f;
            vertexBuffer.addVertex(lastPose, x1, fluidY, z1).setColor(color[0], color[1], color[2], color[3]).setUv(fluidSpriteU0, fluidSpriteV1).setOverlay(combinedOverlayIn).setLight(fluidBrightness).setNormal(0.0f, 0.0f, 1.0f);
            vertexBuffer.addVertex(lastPose, x1, fluidY, z2).setColor(color[0], color[1], color[2], color[3]).setUv(fluidSpriteU0, fluidSpriteV0).setOverlay(combinedOverlayIn).setLight(fluidBrightness).setNormal(0.0f, 0.0f, 1.0f);
            vertexBuffer.addVertex(lastPose, x2, fluidY, z2).setColor(color[0], color[1], color[2], color[3]).setUv(fluidSpriteU1, fluidSpriteV0).setOverlay(combinedOverlayIn).setLight(fluidBrightness).setNormal(0.0f, 0.0f, 1.0f);
            vertexBuffer.addVertex(lastPose, x2, fluidY, z1).setColor(color[0], color[1], color[2], color[3]).setUv(fluidSpriteU1, fluidSpriteV1).setOverlay(combinedOverlayIn).setLight(fluidBrightness).setNormal(0.0f, 0.0f, 1.0f);
            poseStack.popPose();
        }
    }
}

