/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.client.particle;

import cy.jdkdigital.treetap.client.particle.ColoredParticleType;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class ColoredDripParticle
extends DripParticle {
    public ColoredDripParticle(ClientLevel world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z, fluid);
        this.lifetime = (int)(16.0 / (world.random.nextDouble() * 0.8 + 0.2));
        this.gravity = 0.007f;
    }

    protected void postMoveUpdate() {
        if (this.onGround) {
            this.remove();
        }
    }

    public static class ColoredDripParticleFactory
    implements ParticleProvider<ColoredParticleType> {
        protected final SpriteSet sprite;

        public ColoredDripParticleFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(@Nonnull ColoredParticleType typeIn, @Nonnull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ColoredDripParticle dripparticle = new ColoredDripParticle(world, x, y, z, Fluids.EMPTY);
            float[] colors = typeIn.getColor();
            if (colors != null) {
                dripparticle.setColor(colors[0], colors[1], colors[2]);
            } else {
                dripparticle.setColor(0.92f, 0.782f, 0.72f);
            }
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }
}

