/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.display.math;

import com.mojang.math.Axis;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public enum RotationAxis {
    X(Axis.XP, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, -1.0f, -1.0f), new Vector3f(0.0f, -1.0f, 0.0f)),
    Y(Axis.YP, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, -1.0f)),
    Z(Axis.ZP, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f));

    private final Quaternionf[] quaternions;
    private final Vector3f[] offsets;

    private RotationAxis(Axis axis, Vector3f offsetA, Vector3f offsetB, Vector3f offsetC, Vector3f offsetD) {
        this.quaternions = new Quaternionf[]{axis.rotationDegrees(0.0f), axis.rotationDegrees(90.0f), axis.rotationDegrees(180.0f), axis.rotationDegrees(270.0f)};
        this.offsets = new Vector3f[]{offsetA, offsetB, offsetC, offsetD};
    }

    public Quaternionf getRotation(int index) {
        if (index < 0 || index > 3) {
            throw new IndexOutOfBoundsException("Rotation must be a number from 0 to 3.");
        }
        return this.quaternions[index];
    }

    public Vector3f getOffset(int index) {
        if (index < 0 || index > 3) {
            throw new IndexOutOfBoundsException("Offset must be a number from 0 to 3.");
        }
        return this.offsets[index];
    }
}

