/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.context;

import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.config.Config;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockEntityContext(BotanyPotBlockEntity pot, @Nullable Player player, @Nullable InteractionHand hand) implements BotanyPotContext
{
    @NotNull
    public ItemStack getItem(int slotId) {
        return this.pot.getItem(slotId);
    }

    public int size() {
        return this.pot.getContainerSize();
    }

    @Override
    public ItemStack getSoilItem() {
        return this.pot.getSoilItem();
    }

    @Override
    public ItemStack getSeedItem() {
        return this.pot.getSeedItem();
    }

    @Override
    public ItemStack getHarvestItem() {
        return this.pot.getHarvestItem();
    }

    @Override
    public LootParams createLootParams(@Nullable BlockState state) {
        Level level = this.pot.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            LootParams.Builder paramBuilder = new LootParams.Builder(level2);
            paramBuilder.withParameter(LootContextParams.BLOCK_STATE, (Object)(state != null ? state : level2.getBlockState(this.pot.getBlockPos())));
            paramBuilder.withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.pot.getBlockPos()));
            paramBuilder.withParameter(LootContextParams.TOOL, (Object)this.getInteractionItem());
            paramBuilder.withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this.player);
            paramBuilder.withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)this.pot);
            paramBuilder.withOptionalParameter(LootContextParams.TOOL, (Object)(this.pot.getHarvestItem().isEmpty() ? (ItemStack)((Config)BotanyPotsMod.CONFIG.get()).gameplay.default_harvest_tool.apply((Level)level2) : this.pot.getHarvestItem()));
            return paramBuilder.create(LootContextParamSets.BLOCK);
        }
        throw new IllegalStateException("Can not create LootParams on the client!");
    }

    @Override
    public void runFunction(ResourceLocation functionId) {
        this.pot.runFunction(functionId);
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public ItemStack getInteractionItem() {
        return this.player != null && this.hand != null ? this.player.getItemInHand(this.hand) : ItemStack.EMPTY;
    }

    @Override
    public int getRequiredGrowthTicks() {
        return this.pot.getRequiredGrowthTicks();
    }

    @Override
    public boolean isServerThread() {
        Level level = this.pot.getLevel();
        if (level == null && this.player != null) {
            level = this.player.level();
        }
        return level != null && !level.isClientSide;
    }

    @Override
    @Nullable
    public Crop getCrop() {
        return this.pot.getOrInvalidateCrop();
    }

    @Override
    @Nullable
    public Soil getSoil() {
        return this.pot.getOrInvalidateSoil();
    }

    public BlockInWorld blockInWorld() {
        return new BlockInWorld((LevelReader)this.pot.getLevel(), this.pot.getBlockPos(), false);
    }
}

