/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.command.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class DataHelper {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final DefaultedRegistry<Block> BLOCKS = BuiltInRegistries.BLOCK;
    public static final DefaultedRegistry<Item> ITEMS = BuiltInRegistries.ITEM;

    public static JsonObject requiresBlock(Block block) {
        return DataHelper.object("{\"type\":\"bookshelf:block_exists\",\"values\": [\"" + String.valueOf(BLOCKS.getKey((Object)block)) + "\"]}");
    }

    public static JsonObject requiresItem(Item item) {
        return DataHelper.object("{\"type\":\"bookshelf:item_exists\",\"values\": [\"" + String.valueOf(ITEMS.getKey((Object)item)) + "\"]}");
    }

    public static JsonObject item(Item item) {
        return DataHelper.object("{\"item\":\"" + String.valueOf(ITEMS.getKey((Object)item)) + "\"}");
    }

    public static JsonObject tag(TagKey<?> tag) {
        return DataHelper.tag(tag.location());
    }

    public static JsonObject tag(ResourceLocation tag) {
        return DataHelper.object("{\"tag\":\"" + String.valueOf(tag) + "\"}");
    }

    public static JsonElement stack(ItemStack stack) {
        return DataHelper.encode(ItemStack.CODEC, stack);
    }

    public static JsonElement ingredient(Ingredient ingredient) {
        return DataHelper.encode(Ingredient.CODEC, ingredient);
    }

    public static JsonObject simpleDisplay(Block block) {
        return DataHelper.simpleDisplay(block, false);
    }

    public static JsonObject blockTag(TagKey<Block> tag) {
        return DataHelper.blockTag(tag.location());
    }

    public static JsonObject blockTag(ResourceLocation tag) {
        JsonObject object = DataHelper.ingredientBase("bookshelf:block_tag");
        object.addProperty("tag", tag.toString());
        return object;
    }

    public static JsonObject ingredients(JsonObject ... objects) {
        JsonObject object = DataHelper.ingredientBase("bookshelf:either");
        JsonArray array = new JsonArray();
        for (JsonObject obj : objects) {
            array.add((JsonElement)obj);
        }
        object.add("ingredients", (JsonElement)array);
        return object;
    }

    public static JsonObject ingredientBase(ResourceLocation type) {
        return DataHelper.ingredientBase(type.toString());
    }

    public static JsonObject ingredientBase(String type) {
        JsonObject object = new JsonObject();
        object.addProperty("type", type);
        object.addProperty("fabric:type", type);
        return object;
    }

    public static JsonObject simpleDisplay(Block block, boolean fluid) {
        JsonObject out = new JsonObject();
        out.addProperty("type", "botanypots:simple");
        out.add("block_state", (JsonElement)DataHelper.object("{\"block\":\"" + String.valueOf(BLOCKS.getKey((Object)block)) + "\"}"));
        if (fluid) {
            out.add("options", (JsonElement)DataHelper.object("{\"render_fluid\":true}"));
        }
        return out;
    }

    public static JsonArray array(JsonElement ... elements) {
        JsonArray array = new JsonArray();
        for (JsonElement element : elements) {
            array.add(element);
        }
        return array;
    }

    public static JsonObject object(String raw) {
        return (JsonObject)GSON.fromJson(raw, JsonObject.class);
    }

    public static <T> JsonElement encode(Codec<T> codec, T value) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
    }
}

