/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.screens;

import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum FormatStyle implements StringRepresentable
{
    MODE_FULL("Full"),
    MODE_COMPACT("Compact"),
    MODE_COMMAS("Commas");

    private final String name;
    public static final Codec<FormatStyle> CODEC;
    public static final StreamCodec<FriendlyByteBuf, FormatStyle> STREAM_CODEC;

    private FormatStyle(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static FormatStyle getStyle(String name) {
        for (FormatStyle style : FormatStyle.values()) {
            if (!name.equals(style.getName())) continue;
            return style;
        }
        return MODE_FULL;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(FormatStyle::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(FormatStyle.class);
    }
}

