/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.text;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public final class TextHelper {
    public static final Function<@NotNull MutableComponent, @NotNull MutableComponent> IDENTITY_TEXT_POST_PROCESSOR = $ -> $;

    public static MutableComponent literal(String text) {
        return Strings.isNullOrEmpty((String)text) ? Component.empty() : Component.literal((String)text);
    }

    public static MutableComponent literal(String text, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor) {
        Preconditions.checkNotNull(textPostProcessor, (Object)"Text post processor must not be null or empty.");
        return textPostProcessor.apply(TextHelper.literal(text));
    }

    public static MutableComponent literal(String format, Object ... arguments) {
        return TextHelper.literal(String.format(format, arguments));
    }

    public static MutableComponent literal(String format, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor, Object ... arguments) {
        return TextHelper.literal(String.format(format, arguments), textPostProcessor);
    }

    public static MutableComponent translatable(String langKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)langKey) ? 1 : 0) != 0, (Object)"Lang key must not be null or empty.");
        return Component.translatable((String)langKey);
    }

    public static MutableComponent translatable(String langKey, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor) {
        Preconditions.checkNotNull(textPostProcessor, (Object)"Text post processor must not be null or empty.");
        return textPostProcessor.apply(TextHelper.translatable(langKey));
    }

    public static MutableComponent translatable(String langKey, Object ... arguments) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)langKey) ? 1 : 0) != 0, (Object)"Lang key must not be null or empty.");
        Preconditions.checkArgument((arguments.length > 0 ? 1 : 0) != 0, (Object)"Arguments must not be empty.");
        return Component.translatable((String)langKey, (Object[])arguments);
    }

    public static MutableComponent translatable(String langKey, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor, Object ... arguments) {
        Preconditions.checkNotNull(textPostProcessor, (Object)"Text post processor must not be null or empty.");
        return textPostProcessor.apply(TextHelper.translatable(langKey, arguments));
    }

    private TextHelper() {
    }
}

