/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public abstract class AbstractOneToOneRecipe<Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>>
extends ModRecipe
implements Predicate<Ingredient> {
    private final RecipeIngredient _ingredient;
    private final RecipeResult _result;

    protected AbstractOneToOneRecipe(RecipeIngredient ingredient, RecipeResult result) {
        this._ingredient = ingredient;
        this._result = result;
    }

    public static <Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractOneToOneRecipe<Ingredient, Result, RecipeIngredient, RecipeResult>> RecipeSerializer<Recipe> createSerializer(String ingredientFieldName, ModCodecs<RecipeIngredient, RegistryFriendlyByteBuf> ingredientCodecs, String resultFieldName, ModCodecs<RecipeResult, RegistryFriendlyByteBuf> resultCodecs, BiFunction<RecipeIngredient, RecipeResult, Recipe> recipeFactory) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ingredientFieldName) ? 1 : 0) != 0, (Object)"Ingredient field name must not be null nor empty");
        Preconditions.checkNotNull(ingredientCodecs, (Object)"Ingredient codecs must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resultFieldName) ? 1 : 0) != 0, (Object)"Result field name must not be null nor empty");
        Preconditions.checkNotNull(resultCodecs, (Object)"Result codecs must not be null");
        Preconditions.checkNotNull(recipeFactory, (Object)"Recipe factory must not be null");
        final MapCodec codec = RecordCodecBuilder.mapCodec(instance -> instance.group(ingredientCodecs.field(ingredientFieldName, AbstractOneToOneRecipe::getIngredient), resultCodecs.field(resultFieldName, AbstractOneToOneRecipe::getResult)).apply((Applicative)instance, recipeFactory));
        final StreamCodec streamCodec = StreamCodec.composite(ingredientCodecs.streamCodec(), AbstractOneToOneRecipe::getIngredient, resultCodecs.streamCodec(), AbstractOneToOneRecipe::getResult, recipeFactory);
        return new RecipeSerializer<Recipe>(){

            public MapCodec<Recipe> codec() {
                return codec;
            }

            public StreamCodec<RegistryFriendlyByteBuf, Recipe> streamCodec() {
                return streamCodec;
            }
        };
    }

    public RecipeIngredient getIngredient() {
        return this._ingredient;
    }

    public RecipeResult getResult() {
        return this._result;
    }

    @Override
    public boolean test(Ingredient stack) {
        return this.getIngredient().test(stack);
    }

    public NonNullList<Ingredient> getIngredients() {
        return AbstractOneToOneRecipe.buildVanillaIngredientsList(this.getIngredient().asVanillaIngredients());
    }
}

