/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.storage.collection;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.storage.collection.IPartCollection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PartCollection<Controller extends IMultiblockController<Controller>, Part extends IMultiblockPart<Controller>>
implements IPartCollection<Controller, Part> {
    private final int _initialSize;
    private final Predicate<@NotNull IMultiblockPart<Controller>> _validator;
    private ObjectList<Part> _list;

    public PartCollection(int initialSize, Predicate<@NotNull IMultiblockPart<Controller>> validator) {
        this._initialSize = initialSize;
        this._validator = validator;
        this._list = ObjectLists.emptyList();
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    @Override
    public boolean add(IMultiblockPart<Controller> part) {
        if (ObjectLists.emptyList() == this._list) {
            this._list = new ObjectArrayList(this._initialSize);
        }
        return this._list.add(part);
    }

    @Override
    public boolean remove(IMultiblockPart<Controller> part) {
        boolean result = false;
        if (ObjectLists.emptyList() != this._list) {
            result = this._list.remove(part);
        }
        if (this._list.isEmpty()) {
            this._list = ObjectLists.emptyList();
        }
        return result;
    }

    @Override
    public void clear() {
        this._list = ObjectLists.emptyList();
    }

    @Override
    public Stream<Part> stream() {
        return this._list.stream();
    }

    @Override
    public Stream<Part> parallelStream() {
        return this._list.parallelStream();
    }

    @Override
    public Iterator<Part> iterator() {
        return this._list.iterator();
    }

    @Override
    public boolean test(IMultiblockPart<Controller> part) {
        return this._validator.test(part);
    }

    @Override
    public List<Part> asList() {
        return new ObjectArrayList(this._list);
    }
}

