/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.slot.type;

import it.zerono.mods.zerocore.internal.mixin.SlotAccessor;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.item.inventory.IInventorySlot;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.ISlotNotify;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotTemplate;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SlotGeneric
extends SlotItemHandler
implements IInventorySlot {
    private final SlotTemplate _template;
    private final SlotFactory _factory;

    public SlotGeneric(IItemHandler itemHandler, SlotFactory slotFactory) {
        super(itemHandler, slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY());
        this._template = slotFactory.getTemplate();
        this._factory = slotFactory;
    }

    public SlotTemplate getTemplate() {
        return this._template;
    }

    public SlotFactory getFactory() {
        return this._factory;
    }

    public void translate(BiFunction<Integer, Integer, Point> mapper) {
        SlotGeneric.setPos(this, mapper.apply(this.getFactory().getX(), this.getFactory().getY()));
    }

    public boolean mayPlace(ItemStack stack) {
        return this.getTemplate().match(this.getSlotIndex(), stack);
    }

    public void set(ItemStack stack) {
        IItemHandler itemHandler = this.getItemHandler();
        if (itemHandler instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)itemHandler).setStackInSlot(this.getSlotIndex(), stack);
            this.setChanged();
            if (itemHandler instanceof ISlotNotify) {
                ((ISlotNotify)itemHandler).onSlotChanged(itemHandler, this.getSlotIndex(), stack);
            }
        }
    }

    @Override
    public int getIndex() {
        return this.getSlotIndex();
    }

    @Override
    public ItemStack getStackInSlot() {
        return this.getItem();
    }

    @Override
    public void setStackInSlot(ItemStack stack) {
        this.set(stack);
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        ItemStack remainder = this.getItemHandler().insertItem(this.getIndex(), stack, true);
        return remainder.isEmpty() || remainder.getCount() < stack.getCount();
    }

    @Override
    public boolean canExtractStack(int amount) {
        ItemStack remainder = this.getItemHandler().extractItem(this.getIndex(), amount, true);
        return !remainder.isEmpty() && amount == remainder.getCount();
    }

    @Override
    public int getSlotLimit(ItemStack stack) {
        return stack.isEmpty() ? this.getMaxStackSize() : Math.min(this.getMaxStackSize(), stack.getMaxStackSize());
    }

    private static void setPos(SlotGeneric slot, Point pos) {
        SlotAccessor accessor = (SlotAccessor)((Object)slot);
        accessor.zerocore_setX(pos.X);
        accessor.zerocore_setY(pos.Y);
    }
}

