/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum EnergySystem implements StringRepresentable
{
    ForgeEnergy("Forge Energy", "FE", 1.0),
    RedstoneFlux("Redstone Flux", "RF", 1.0),
    Tesla("Tesla", "T", 1.0),
    EnergyUnit("Energy Units", "EU", 0.25),
    MinecraftJoules("Minecraft Joules", "MJ", 0.1),
    Joules("Joules", "J", 2.5),
    GalacticraftJoules("Galacticraft Joules", "gJ", 1.6);

    public static final IntFunction<EnergySystem> BY_ID;
    public static final ModCodecs<EnergySystem, ByteBuf> CODECS;
    public static final EnergySystem REFERENCE;
    private final String _name;
    private final String _unit;
    private final double _conversionRatio;
    private final WideAmount _conversionRatioWide;

    private EnergySystem(String name, String unit, double conversionRatio) {
        this._name = name;
        this._unit = unit;
        this._conversionRatio = conversionRatio;
        this._conversionRatioWide = WideAmount.asImmutable(conversionRatio);
    }

    public static EnergySystem read(CompoundTag data, String key, EnergySystem defaultValue) {
        String value;
        if (data.contains(key) && !Strings.isNullOrEmpty((String)(value = data.getString(key)))) {
            return EnergySystem.valueOf(value);
        }
        return defaultValue;
    }

    public static void write(CompoundTag data, String key, EnergySystem value) {
        data.putString(key, value.name());
    }

    public double convertTo(EnergySystem target, double amount) {
        return amount / this.getConversionRatio() * target.getConversionRatio();
    }

    public WideAmount convertTo(EnergySystem target, WideAmount amount) {
        return amount.divide(this._conversionRatioWide).multiply(target._conversionRatioWide);
    }

    public String getFullName() {
        return this._name;
    }

    public String getUnit() {
        return this._unit;
    }

    public double getConversionRatio() {
        return this._conversionRatio;
    }

    public String asHumanReadableNumber(double value) {
        return CodeHelper.formatAsHumanReadableNumber(value, this.getUnit());
    }

    public String asHumanReadableNumber(WideAmount value) {
        return CodeHelper.formatAsHumanReadableNumber(value, this.getUnit());
    }

    public String getSerializedName() {
        return this._name;
    }

    public String toString() {
        return this.getUnit();
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])EnergySystem.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODECS = new ModCodecs(StringRepresentable.fromEnum(EnergySystem::values), ByteBufCodecs.idMapper(BY_ID, Enum::ordinal));
        REFERENCE = ForgeEnergy;
    }
}

