/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.AbstractDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.MultiPartBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.MultiVariantBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.SingleVariantBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.jetbrains.annotations.NotNull;

public abstract class BlockStateDataProvider
extends AbstractDataProvider {
    private final Map<Block, BlockStateGenerator> _generators;
    private final ModelBuilder _models;
    private final PackOutput.PathProvider _pathProvider;
    private final ResourceLocationBuilder _blocksRoot;
    private final ResourceLocationBuilder _itemsRoot;

    public BlockStateDataProvider(String name, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ResourceLocationBuilder modLocationRoot) {
        super(name, output, lookupProvider, modLocationRoot);
        this._pathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this._generators = new Object2ObjectArrayMap(128);
        this._models = new ModelBuilder(output);
        this._blocksRoot = modLocationRoot.appendPath("block/");
        this._itemsRoot = modLocationRoot.appendPath("item/");
    }

    public ResourceLocationBuilder blocksRoot() {
        return this._blocksRoot;
    }

    public ResourceLocationBuilder itemsRoot() {
        return this._itemsRoot;
    }

    public final ModelBuilder models() {
        return this._models;
    }

    public <B extends Block> SingleVariantBuilder singleVariant(B block) {
        return this.add(new SingleVariantBuilder(this._models, block));
    }

    public <B extends Block> SingleVariantBuilder singleVariant(Supplier<B> block) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.singleVariant((Block)block.get());
    }

    public <B extends Block> MultiVariantBuilder multiVariant(B block) {
        return this.add(new MultiVariantBuilder(this._models, block));
    }

    public <B extends Block> MultiVariantBuilder multiVariant(B block, Property<?> ... ignoredProperties) {
        return this.add(new MultiVariantBuilder(this._models, block, (Set<Property<?>>)ImmutableSet.copyOf((Object[])ignoredProperties)));
    }

    public <B extends Block> MultiVariantBuilder multiVariant(Supplier<B> block) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.multiVariant((Block)block.get());
    }

    public <B extends Block> MultiVariantBuilder multiVariant(Supplier<B> block, Property<?> ... ignoredProperties) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.multiVariant((Block)block.get(), ignoredProperties);
    }

    public <B extends Block> MultiPartBuilder multiPart(B block) {
        return this.add(new MultiPartBuilder(this._models, block));
    }

    public <B extends Block> MultiPartBuilder multiPart(Supplier<B> block) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.multiPart((Block)block.get());
    }

    public <B extends Block> ResourceLocation defaultBlockTexture(Supplier<B> block) {
        return this.models().defaultBlockTexture(block);
    }

    public <I extends ItemLike> ResourceLocation defaultItemTexture(Supplier<I> item) {
        return this.models().defaultItemTexture(item);
    }

    public <B extends Block> void simpleBlock(Supplier<B> block) {
        this.cube(block, this.defaultBlockTexture(block));
    }

    public <I extends ItemLike> void simpleItem(Supplier<I> item) {
        this.models().item(item).flatItem(this.defaultItemTexture(item));
    }

    public <B extends Block> void axisAligned(Supplier<B> block, Function<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Direction.Axis, @NotNull ResourceLocation> modelProvider) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        Preconditions.checkNotNull(modelProvider, (Object)"Model provider must not be null");
        this.multiVariant(block).selector(BlockStateProperties.AXIS, Direction.Axis.X, variant -> variant.model((ResourceLocation)modelProvider.apply(Direction.Axis.X)).xRotation(90).yRotation(90)).selector(BlockStateProperties.AXIS, Direction.Axis.Y, variant -> variant.model((ResourceLocation)modelProvider.apply(Direction.Axis.Y))).selector(BlockStateProperties.AXIS, Direction.Axis.Z, variant -> variant.model((ResourceLocation)modelProvider.apply(Direction.Axis.Z)).xRotation(90));
    }

    public <B extends Block> void axisAligned(Supplier<B> block, ResourceLocation model) {
        this.axisAligned(block, (Direction.Axis $) -> model);
    }

    public <B extends Block> void cube(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation model = this.models().block(block).delegateFor(block).cube(texture);
        this.singleVariant(block).model(model);
    }

    public <B extends Block> void wood(Supplier<B> block, ResourceLocation texture) {
        this.axisAligned(block, this.models().block(block).delegateFor(block).wood(texture));
    }

    public <B extends Block> void woodLog(Supplier<B> block, ResourceLocation side, ResourceLocation ends) {
        ResourceLocation vertical = this.models().block(block).delegateFor(block).woodVerticalLog(side, ends);
        ResourceLocation horizontal = this.models().block(block, "_horizontal").woodHorizontalLog(side, ends);
        this.axisAligned(block, (Direction.Axis axis) -> axis.isVertical() ? vertical : horizontal);
    }

    public <B extends Block> void woodPlanks(Supplier<B> block, ResourceLocation texture) {
        this.singleVariant(block).model(this.models().block(block).delegateFor(block).woodPLanks(texture));
    }

    public <B extends DoorBlock> void door(Supplier<B> block, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation itemTexture) {
        ResourceLocation[] models = new ResourceLocation[]{this.models().block(block, "_bottom_left").doorClosedBottomLeft(bottomTexture), this.models().block(block, "_bottom_right").doorClosedBottomRight(bottomTexture), this.models().block(block, "_top_left").doorClosedTopLeft(topTexture), this.models().block(block, "_top_right").doorClosedTopRight(topTexture), this.models().block(block, "_bottom_left_open").doorOpenBottomLeft(bottomTexture), this.models().block(block, "_bottom_right_open").doorOpenBottomRight(bottomTexture), this.models().block(block, "_top_left_open").doorOpenTopLeft(topTexture), this.models().block(block, "_top_right_open").doorOpenTopRight(topTexture)};
        this.multiVariant(block, new Property[]{DoorBlock.POWERED}).all((state, builder) -> {
            DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)DoorBlock.HINGE);
            boolean isOpen = (Boolean)state.getValue((Property)DoorBlock.OPEN);
            int modelIndex = 0;
            int yRotation = 90 + (int)((Direction)state.getValue((Property)DoorBlock.FACING)).toYRot();
            if (DoorHingeSide.RIGHT == hinge) {
                modelIndex |= 1;
            }
            if (DoubleBlockHalf.UPPER == state.getValue((Property)DoorBlock.HALF)) {
                modelIndex |= 2;
            }
            if (isOpen) {
                modelIndex |= 4;
                yRotation += 90;
                if (DoorHingeSide.RIGHT == hinge) {
                    yRotation += 180;
                }
            }
            builder.model(models[modelIndex]).yRotation(yRotation %= 360);
        });
        this.models().item(block).doorItem(itemTexture);
    }

    public <B extends Block> void button(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation nonPressed = this.models().block(block).button(false, texture);
        ResourceLocation pressed = this.models().block(block, "_pressed").button(true, texture);
        this.multiVariant(block).all((state, builder) -> {
            ResourceLocation model = (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? pressed : nonPressed;
            VariantProperties.Rotation xRotation = VariantProperties.Rotation.R0;
            VariantProperties.Rotation yRotation = VariantProperties.Rotation.R0;
            boolean uvLock = false;
            switch ((AttachFace)state.getValue((Property)BlockStateProperties.ATTACH_FACE)) {
                case CEILING: {
                    xRotation = VariantProperties.Rotation.R180;
                    yRotation = switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        case Direction.EAST -> VariantProperties.Rotation.R270;
                        case Direction.WEST -> VariantProperties.Rotation.R90;
                        case Direction.SOUTH -> VariantProperties.Rotation.R0;
                        case Direction.NORTH -> VariantProperties.Rotation.R180;
                        default -> throw new IllegalArgumentException("Invalid facing");
                    };
                    break;
                }
                case WALL: {
                    uvLock = true;
                    xRotation = VariantProperties.Rotation.R90;
                    yRotation = switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        case Direction.EAST -> VariantProperties.Rotation.R90;
                        case Direction.WEST -> VariantProperties.Rotation.R270;
                        case Direction.SOUTH -> VariantProperties.Rotation.R180;
                        case Direction.NORTH -> VariantProperties.Rotation.R0;
                        default -> throw new IllegalArgumentException("Invalid facing");
                    };
                    break;
                }
                case FLOOR: {
                    yRotation = switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        case Direction.EAST -> VariantProperties.Rotation.R90;
                        case Direction.WEST -> VariantProperties.Rotation.R270;
                        case Direction.SOUTH -> VariantProperties.Rotation.R180;
                        case Direction.NORTH -> VariantProperties.Rotation.R0;
                        default -> throw new IllegalArgumentException("Invalid facing");
                    };
                }
            }
            builder.model(model).xRotation(xRotation).yRotation(yRotation).uvLock(uvLock);
        });
        this.models().item(block).buttonItem(texture);
    }

    public <B extends Block> void fence(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation post = this.models().block(block, "_post").fencePost(texture);
        ResourceLocation side = this.models().block(block, "_side").fenceSide(texture);
        this.multiPart(block).part(variant -> variant.model(post)).part(BlockStateProperties.NORTH, Boolean.valueOf(true), variant -> variant.model(side).uvLock()).part(BlockStateProperties.EAST, Boolean.valueOf(true), variant -> variant.model(side).uvLock().yRotation(VariantProperties.Rotation.R90)).part(BlockStateProperties.SOUTH, Boolean.valueOf(true), variant -> variant.model(side).uvLock().yRotation(VariantProperties.Rotation.R180)).part(BlockStateProperties.WEST, Boolean.valueOf(true), variant -> variant.model(side).uvLock().yRotation(VariantProperties.Rotation.R270));
        this.models().item(block).fenceItem(texture);
    }

    public <B extends Block> void fenceGate(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation[] models = new ResourceLocation[]{this.models().block(block).delegateFor(block).fenceGateClosed(texture), this.models().block(block, "_open").fenceGateOpen(texture), this.models().block(block, "_wall").fenceGateWallClosed(texture), this.models().block(block, "_wall_open").fenceGateWallOpen(texture)};
        this.multiVariant(block).all((state, builder) -> {
            ModelVariantBuilder modelVariantBuilder = builder.model(models[((Boolean)state.getValue((Property)BlockStateProperties.IN_WALL) != false ? 2 : 0) + ((Boolean)state.getValue((Property)BlockStateProperties.OPEN) != false ? 1 : 0)]).uvLock();
            modelVariantBuilder.yRotation(switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                case Direction.EAST -> VariantProperties.Rotation.R270;
                case Direction.NORTH -> VariantProperties.Rotation.R180;
                case Direction.WEST -> VariantProperties.Rotation.R90;
                case Direction.SOUTH -> VariantProperties.Rotation.R0;
                default -> throw new IllegalStateException("Invalid facing value");
            });
        });
    }

    public <B extends Block> void wall(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation post = this.models().block(block, "_post").wallPost(texture);
        ResourceLocation lowSide = this.models().block(block, "_side").wallLowSide(texture);
        ResourceLocation tallSide = this.models().block(block, "_side_tall").wallTallSide(texture);
        this.multiPart(block).part(BlockStateProperties.UP, Boolean.valueOf(true), variant -> variant.model(post)).part(BlockStateProperties.NORTH_WALL, WallSide.LOW, variant -> variant.model(lowSide).uvLock()).part(BlockStateProperties.EAST_WALL, WallSide.LOW, variant -> variant.model(lowSide).uvLock().yRotation(90)).part(BlockStateProperties.SOUTH_WALL, WallSide.LOW, variant -> variant.model(lowSide).uvLock().yRotation(180)).part(BlockStateProperties.WEST_WALL, WallSide.LOW, variant -> variant.model(lowSide).uvLock().yRotation(270)).part(BlockStateProperties.NORTH_WALL, WallSide.TALL, variant -> variant.model(tallSide).uvLock()).part(BlockStateProperties.EAST_WALL, WallSide.TALL, variant -> variant.model(tallSide).uvLock().yRotation(90)).part(BlockStateProperties.SOUTH_WALL, WallSide.TALL, variant -> variant.model(tallSide).uvLock().yRotation(180)).part(BlockStateProperties.WEST_WALL, WallSide.TALL, variant -> variant.model(tallSide).uvLock().yRotation(270));
        this.models().item(block).wallItem(texture);
    }

    public <B extends Block> void pressurePlate(Supplier<B> block, ResourceLocation texture) {
        this.multiVariant(block).selector(BlockStateProperties.POWERED, Boolean.valueOf(false), variant -> variant.model(arg_0 -> BlockStateDataProvider.lambda$pressurePlate$22((Supplier)block, texture, arg_0))).selector(BlockStateProperties.POWERED, Boolean.valueOf(true), variant -> variant.model(arg_0 -> BlockStateDataProvider.lambda$pressurePlate$24((Supplier)block, texture, arg_0)));
    }

    public void slab(Supplier<SlabBlock> block, ResourceLocation doubleSlabsModel, ResourceLocation texture) {
        this.slab(block, doubleSlabsModel, texture, texture, texture);
    }

    public void slab(Supplier<SlabBlock> block, ResourceLocation doubleSlabsModel, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        this.multiVariant(block, new Property[]{BlockStateProperties.WATERLOGGED}).selector(SlabBlock.TYPE, SlabType.BOTTOM, variant -> variant.model(arg_0 -> BlockStateDataProvider.lambda$slab$26((Supplier)block, bottom, top, side, arg_0))).selector(SlabBlock.TYPE, SlabType.TOP, variant -> variant.model(arg_0 -> BlockStateDataProvider.lambda$slab$28((Supplier)block, bottom, top, side, arg_0))).selector(SlabBlock.TYPE, SlabType.DOUBLE, variant -> variant.model(doubleSlabsModel));
    }

    public <B extends Block> void leaves(Supplier<B> block, ResourceLocation texture) {
        this.singleVariant(block).variant(variant -> variant.model(arg_0 -> BlockStateDataProvider.lambda$leaves$31((Supplier)block, texture, arg_0)));
    }

    public void stairs(Supplier<StairBlock> block, ResourceLocation texture) {
        this.stairs(block, texture, texture, texture);
    }

    public void stairs(Supplier<StairBlock> block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        ResourceLocation straight = this.models().block(block).delegateFor(block).stairsStraight(bottom, top, side);
        ResourceLocation inner = this.models().block(block, "_inner").stairsInner(bottom, top, side);
        ResourceLocation outer = this.models().block(block, "_outer").stairsOuter(bottom, top, side);
        this.multiVariant(block, new Property[]{StairBlock.WATERLOGGED}).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.INNER_LEFT).variant(variant -> variant.model(inner).uvLock().yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.INNER_RIGHT).variant(variant -> variant.model(inner))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.OUTER_LEFT).variant(variant -> variant.model(outer).uvLock().yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.OUTER_RIGHT).variant(variant -> variant.model(outer))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.STRAIGHT).variant(variant -> variant.model(straight))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.INNER_LEFT).variant(variant -> variant.model(inner).uvLock().xRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.INNER_RIGHT).variant(variant -> variant.model(inner).uvLock().xRotation(180).yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.OUTER_LEFT).variant(variant -> variant.model(outer).uvLock().xRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.OUTER_RIGHT).variant(variant -> variant.model(outer).uvLock().xRotation(180).yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.EAST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.STRAIGHT).variant(variant -> variant.model(straight).uvLock().xRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.INNER_LEFT).variant(variant -> variant.model(inner).uvLock().yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.INNER_RIGHT).variant(variant -> variant.model(inner).uvLock().yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.OUTER_LEFT).variant(variant -> variant.model(outer).uvLock().yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.OUTER_RIGHT).variant(variant -> variant.model(outer).uvLock().yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.STRAIGHT).variant(variant -> variant.model(straight).uvLock().yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.INNER_LEFT).variant(variant -> variant.model(inner).uvLock().xRotation(180).yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.INNER_RIGHT).variant(variant -> variant.model(inner).uvLock().xRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.OUTER_LEFT).variant(variant -> variant.model(outer).uvLock().xRotation(180).yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.OUTER_RIGHT).variant(variant -> variant.model(outer).uvLock().xRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.NORTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.STRAIGHT).variant(variant -> variant.model(straight).uvLock().xRotation(180).yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.INNER_LEFT).variant(variant -> variant.model(inner))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.INNER_RIGHT).variant(variant -> variant.model(inner).uvLock().yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.OUTER_LEFT).variant(variant -> variant.model(outer))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.OUTER_RIGHT).variant(variant -> variant.model(outer).uvLock().yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.STRAIGHT).variant(variant -> variant.model(straight).uvLock().yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.INNER_LEFT).variant(variant -> variant.model(inner).uvLock().xRotation(180).yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.INNER_RIGHT).variant(variant -> variant.model(inner).uvLock().xRotation(180).yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.OUTER_LEFT).variant(variant -> variant.model(outer).uvLock().xRotation(180).yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.OUTER_RIGHT).variant(variant -> variant.model(outer).uvLock().xRotation(180).yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.SOUTH).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.STRAIGHT).variant(variant -> variant.model(straight).uvLock().xRotation(180).yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.INNER_LEFT).variant(variant -> variant.model(inner).uvLock().yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.INNER_RIGHT).variant(variant -> variant.model(inner).uvLock().yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.OUTER_LEFT).variant(variant -> variant.model(outer).uvLock().yRotation(90))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.OUTER_RIGHT).variant(variant -> variant.model(outer).uvLock().yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.BOTTOM).state(StairBlock.SHAPE, StairsShape.STRAIGHT).variant(variant -> variant.model(straight).uvLock().yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.INNER_LEFT).variant(variant -> variant.model(inner).uvLock().xRotation(180).yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.INNER_RIGHT).variant(variant -> variant.model(inner).uvLock().xRotation(180).yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.OUTER_LEFT).variant(variant -> variant.model(outer).uvLock().xRotation(180).yRotation(180))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.OUTER_RIGHT).variant(variant -> variant.model(outer).uvLock().xRotation(180).yRotation(270))).selector(selector -> selector.state(StairBlock.FACING, Direction.WEST).state(StairBlock.HALF, Half.TOP).state(StairBlock.SHAPE, StairsShape.STRAIGHT).variant(variant -> variant.model(straight).uvLock().xRotation(180).yRotation(180)));
    }

    public void trapdoor(Supplier<TrapDoorBlock> block, boolean orientable, ResourceLocation texture) {
        ResourceLocation bottom = this.models().block(block, "_bottom").delegateFor(block).trapdoorBottom(orientable, texture);
        ResourceLocation top = this.models().block(block, "_top").trapdoorTop(orientable, texture);
        ResourceLocation open = this.models().block(block, "_open").trapdoorOpen(orientable, texture);
        this.multiVariant(block, new Property[]{TrapDoorBlock.POWERED, TrapDoorBlock.WATERLOGGED}).all((state, builder) -> {
            boolean isOpen = (Boolean)state.getValue((Property)TrapDoorBlock.OPEN);
            boolean isTop = Half.TOP == state.getValue((Property)TrapDoorBlock.HALF);
            int xRotation = 0;
            int yRotation = 180 + (int)((Direction)state.getValue((Property)TrapDoorBlock.FACING)).toYRot();
            if (orientable && isOpen) {
                if (isTop) {
                    xRotation += 180;
                    yRotation += 180;
                }
            } else {
                yRotation = 0;
            }
            builder.model(isOpen ? open : (isTop ? top : bottom)).xRotation(xRotation).yRotation(yRotation %= 360);
        });
    }

    public <B extends Block> void passiveRail(Supplier<B> block, ResourceLocation texture, ResourceLocation cornerTexture) {
        ResourceLocation flat = this.models().block(block).railFlat(texture);
        ResourceLocation corner = this.models().block(block, "_corner").railCorner(cornerTexture);
        ResourceLocation raisedNE = this.models().block(block, "_raised_ne").railRaisedNE(texture);
        ResourceLocation raisedSW = this.models().block(block, "_raised_sw").railRaisedSW(texture);
        this.multiVariant(block).all((state, builder) -> {
            ResourceLocation model = corner;
            int yRotation = 0;
            switch ((RailShape)state.getValue((Property)BlockStateProperties.RAIL_SHAPE)) {
                case ASCENDING_EAST: {
                    yRotation = 90;
                }
                case ASCENDING_NORTH: {
                    model = raisedNE;
                    break;
                }
                case ASCENDING_WEST: {
                    yRotation = 90;
                }
                case ASCENDING_SOUTH: {
                    model = raisedSW;
                    break;
                }
                case EAST_WEST: {
                    yRotation = 90;
                }
                case NORTH_SOUTH: {
                    model = flat;
                    break;
                }
                case SOUTH_EAST: {
                    break;
                }
                case SOUTH_WEST: {
                    yRotation = 90;
                    break;
                }
                case NORTH_WEST: {
                    yRotation = 180;
                    break;
                }
                case NORTH_EAST: {
                    yRotation = 270;
                }
            }
            builder.model(model).yRotation(yRotation);
        });
        this.models().item(block).railItem(texture);
    }

    public <B extends Block> void activeRail(Supplier<B> block, ResourceLocation texture) {
        ResourceLocation flat = this.models().block(block).railFlat(texture);
        ResourceLocation raisedNE = this.models().block(block, "_raised_ne").railRaisedNE(texture);
        ResourceLocation raisedSW = this.models().block(block, "_raised_sw").railRaisedSW(texture);
        ResourceLocation onFlat = this.models().block(block, "_on").railFlat(texture);
        ResourceLocation onRaisedNE = this.models().block(block, "_on_raised_ne").railRaisedNE(texture);
        ResourceLocation onRaisedSW = this.models().block(block, "_on_raised_sw").railRaisedSW(texture);
        this.multiVariant(block).all((state, builder) -> {
            ResourceLocation model;
            boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
            int yRotation = 0;
            switch ((RailShape)state.getValue((Property)BlockStateProperties.RAIL_SHAPE_STRAIGHT)) {
                case ASCENDING_EAST: {
                    yRotation = 90;
                }
                case ASCENDING_NORTH: {
                    model = powered ? onRaisedNE : raisedNE;
                    break;
                }
                case ASCENDING_WEST: {
                    yRotation = 90;
                }
                case ASCENDING_SOUTH: {
                    model = powered ? onRaisedSW : raisedSW;
                    break;
                }
                case EAST_WEST: {
                    yRotation = 90;
                }
                case NORTH_SOUTH: {
                    model = powered ? onFlat : flat;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid rail shape");
                }
            }
            builder.model(model).yRotation(yRotation);
        });
        this.models().item(block).railItem(texture);
    }

    public <B extends Block> void glass(Supplier<B> block, ResourceLocation texture) {
        this.cube(block, texture);
    }

    public <B extends Block> void glassPane(Supplier<B> block, ResourceLocation pane, ResourceLocation edge) {
        ResourceLocation post = this.models().block(block, "_post").glassPanePost(pane, edge);
        ResourceLocation side = this.models().block(block, "_side").glassPaneSide(pane, edge);
        ResourceLocation sideAlt = this.models().block(block, "_side_alt").glassPaneSideAlt(pane, edge);
        ResourceLocation noSide = this.models().block(block, "_noside").glassPaneNoSide(pane);
        ResourceLocation noSideAlt = this.models().block(block, "_noside_alt").glassPaneNoSideAlt(pane);
        this.multiPart(block).part(variant -> variant.model(post)).part(BlockStateProperties.NORTH, Boolean.valueOf(true), variant -> variant.model(side)).part(BlockStateProperties.NORTH, Boolean.valueOf(false), variant -> variant.model(noSide)).part(BlockStateProperties.SOUTH, Boolean.valueOf(true), variant -> variant.model(sideAlt)).part(BlockStateProperties.SOUTH, Boolean.valueOf(false), variant -> variant.model(noSideAlt).yRotation(90)).part(BlockStateProperties.WEST, Boolean.valueOf(true), variant -> variant.model(sideAlt).yRotation(90)).part(BlockStateProperties.WEST, Boolean.valueOf(false), variant -> variant.model(noSide).yRotation(270)).part(BlockStateProperties.EAST, Boolean.valueOf(true), variant -> variant.model(side).yRotation(90)).part(BlockStateProperties.EAST, Boolean.valueOf(false), variant -> variant.model(noSideAlt));
        this.models().item(block).glassPaneItem(pane);
    }

    @Override
    public CompletableFuture<?> processData(CachedOutput cache, HolderLookup.Provider registryLookup) {
        ObjectArrayList futures = new ObjectArrayList(1 + this._generators.size());
        futures.add(this._models.apply(cache));
        this._generators.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)((BlockStateGenerator)entry.getValue()).get()), (Path)this._pathProvider.json(CodeHelper.getObjectId((Block)entry.getKey())))).forEachOrdered(((List)futures)::add);
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private <G extends BlockStateGenerator> G add(G generator) {
        Block block = generator.getBlock();
        if (this._generators.containsKey(block)) {
            throw new IllegalStateException("A block state generator is already defined for block " + String.valueOf(block));
        }
        this._generators.put(block, generator);
        return generator;
    }

    private static /* synthetic */ ResourceLocation lambda$leaves$31(Supplier block, ResourceLocation texture, ModelBuilder model) {
        return model.block(block).delegateFor(block).leaves(texture);
    }

    private static /* synthetic */ ResourceLocation lambda$slab$28(Supplier block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ModelBuilder model) {
        return model.block(block, "_top").slab(true, bottom, top, side);
    }

    private static /* synthetic */ ResourceLocation lambda$slab$26(Supplier block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ModelBuilder model) {
        return model.block(block).delegateFor(block).slab(false, bottom, top, side);
    }

    private static /* synthetic */ ResourceLocation lambda$pressurePlate$24(Supplier block, ResourceLocation texture, ModelBuilder model) {
        return model.block(block, "_down").pressurePlate(true, texture);
    }

    private static /* synthetic */ ResourceLocation lambda$pressurePlate$22(Supplier block, ResourceLocation texture, ModelBuilder model) {
        return model.block(block).delegateFor(block).pressurePlate(false, texture);
    }
}

