/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.nbt;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public interface ISyncableEntity {
    default public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, SyncReason syncReason) {
    }

    default public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, SyncReason syncReason) {
        return data;
    }

    default public boolean syncChildDataEntityFrom(ISyncableEntity childEntity, String dataKey, CompoundTag parentData, HolderLookup.Provider registries, SyncReason syncReason) {
        if (parentData.contains(dataKey)) {
            childEntity.syncDataFrom(parentData.getCompound(dataKey), registries, syncReason);
            return true;
        }
        return false;
    }

    default public void syncChildDataEntityTo(ISyncableEntity childEntity, String dataKey, CompoundTag parentData, HolderLookup.Provider registries, SyncReason syncReason) {
        parentData.put(dataKey, (Tag)childEntity.syncDataTo(new CompoundTag(), registries, syncReason));
    }

    default public void syncDataElementFrom(String dataKey, CompoundTag parentData, HolderLookup.Provider registries, Consumer<@NotNull CompoundTag> consumer) {
        if (parentData.contains(dataKey)) {
            consumer.accept(parentData.getCompound(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundTag parentData, HolderLookup.Provider registries, CompoundTag value) {
        parentData.put(dataKey, (Tag)value);
    }

    default public void syncDataElementFrom(String dataKey, CompoundTag parentData, HolderLookup.Provider registries, ItemStackHandler value) {
        if (parentData.contains(dataKey)) {
            value.deserializeNBT(registries, parentData.getCompound(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundTag parentData, HolderLookup.Provider registries, ItemStackHandler value) {
        parentData.put(dataKey, (Tag)value.serializeNBT(registries));
    }

    default public void syncDataElementFrom(String dataKey, CompoundTag parentData, HolderLookup.Provider registries, ItemStackHolder value) {
        if (parentData.contains(dataKey)) {
            value.deserializeNBT(registries, parentData.getCompound(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundTag parentData, HolderLookup.Provider registries, ItemStackHolder value) {
        parentData.put(dataKey, (Tag)value.serializeNBT(registries));
    }

    default public void syncBooleanElementFrom(String dataKey, CompoundTag parentData, HolderLookup.Provider registries, BooleanConsumer consumer) {
        if (parentData.contains(dataKey)) {
            consumer.accept(parentData.getBoolean(dataKey));
        }
    }

    default public void syncBooleanElementTo(String dataKey, CompoundTag parentData, HolderLookup.Provider registries, boolean value) {
        parentData.putBoolean(dataKey, value);
    }

    public static enum SyncReason {
        FullSync,
        NetworkUpdate;


        public boolean isFullSync() {
            return this == FullSync;
        }

        public boolean isNetworkUpdate() {
            return this == NetworkUpdate;
        }
    }
}

