/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector4f;

public class Vector3i {
    public static final Vector3i ZERO = new Vector3i();
    public final int X;
    public final int Y;
    public final int Z;

    public Vector3i(int x, int y, int z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public Vector3i(Vector3i other) {
        this(other.X, other.Y, other.Z);
    }

    public static Vector3i from(Vec3i data) {
        return new Vector3i(data.getX(), data.getY(), data.getZ());
    }

    public static Vector3i from(Vector4f data) {
        return new Vector3i((int)data.x(), (int)data.y(), (int)data.z());
    }

    public static Vector3i from(Entity data) {
        return new Vector3i((int)data.getX(), (int)data.getY(), (int)data.getZ());
    }

    public static Vector3i from(BlockEntity data) {
        return Vector3i.from((Vec3i)data.getBlockPos());
    }

    public static Vector3i syncDataFrom(CompoundTag data) {
        return new Vector3i(data.getInt("vx"), data.getInt("vy"), data.getInt("vz"));
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        data.putInt("vx", this.X);
        data.putInt("vy", this.Y);
        data.putInt("vz", this.Z);
        return data;
    }

    public Vec3i toVec3i() {
        return new Vec3i(this.X, this.Y, this.Z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.X, this.Y, this.Z);
    }

    public Vector3i add(int offsetX, int offsetY, int offsetZ) {
        return new Vector3i(this.X + offsetX, this.Y + offsetY, this.Z + offsetZ);
    }

    public Vector3i add(int offset) {
        return this.add(offset, offset, offset);
    }

    public Vector3i add(Vector3d offset) {
        return this.add((int)offset.X, (int)offset.Y, (int)offset.X);
    }

    public Vector3i add(Vec3i offset) {
        return this.add(offset.getX(), offset.getY(), offset.getZ());
    }

    public Vector3i subtract(int offsetX, int offsetY, int offsetZ) {
        return new Vector3i(this.X - offsetX, this.Y - offsetY, this.Z - offsetZ);
    }

    public Vector3i subtract(int offset) {
        return this.subtract(offset, offset, offset);
    }

    public Vector3i subtract(Vector3i offset) {
        return this.subtract(offset.X, offset.Y, offset.Z);
    }

    public Vector3i multiply(int factorX, int factorY, int factorZ) {
        return new Vector3i(this.X * factorX, this.Y * factorY, this.Z * factorZ);
    }

    public Vector3i multiply(double factorX, double factorY, double factorZ) {
        return new Vector3i((int)((double)this.X * factorX), (int)((double)this.Y * factorY), (int)((double)this.Z * factorZ));
    }

    public Vector3i multiply(int factor) {
        return this.multiply(factor, factor, factor);
    }

    public Vector3i multiply(double factor) {
        return this.multiply(factor, factor, factor);
    }

    public Vector3i multiply(Vector3i factor) {
        return this.multiply(factor.X, factor.Y, factor.Z);
    }

    public Vector3i divide(int factorX, int factorY, int factorZ) {
        return new Vector3i(this.X / factorX, this.Y / factorY, this.Z / factorZ);
    }

    public Vector3i divide(double factorX, double factorY, double factorZ) {
        return new Vector3i((int)((double)this.X / factorX), (int)((double)this.Y / factorY), (int)((double)this.Z / factorZ));
    }

    public Vector3i divide(int factor) {
        return this.divide(factor, factor, factor);
    }

    public Vector3i divide(double factor) {
        return this.divide(factor, factor, factor);
    }

    public Vector3i divide(Vec3i factor) {
        return this.divide(factor.getX(), factor.getY(), factor.getZ());
    }

    public Vector3i ceil() {
        return new Vector3i(Mth.ceil((float)this.X), Mth.ceil((float)this.Y), Mth.ceil((float)this.Z));
    }

    public Vector3i floor() {
        return new Vector3i(Mth.floor((float)this.X), Mth.floor((float)this.Y), Mth.floor((float)this.Z));
    }

    public Vector3i crossProduct(Vector3i vec) {
        return new Vector3i(this.Y * vec.Z - this.Z * vec.Y, this.Z * vec.X - this.X * vec.Z, this.X * vec.Y - this.Y * vec.X);
    }

    public double magnitude() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public Vector3i normalize() {
        double magnitude = this.magnitude();
        if (0.0 != magnitude) {
            return this.multiply(1.0 / magnitude);
        }
        return this;
    }

    public int scalarProduct(int x, int y, int z) {
        return this.X * x + this.Y * y + this.Z * z;
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3i) {
            Vector3i v = (Vector3i)other;
            return this.X == v.X && this.Y == v.Y && this.Z == v.Z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.X, this.Y, this.Z);
    }

    public String toString() {
        return String.format("Vector3i (%d, %d, %d)", this.X, this.Y, this.Z);
    }

    private Vector3i() {
        this.Z = 0;
        this.Y = 0;
        this.X = 0;
    }
}

