/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import it.zerono.mods.zerocore.lib.compat.DependencyServiceLoader;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

public class SidedDependencyServiceLoader<T>
extends DependencyServiceLoader<T> {
    private final Dist _distribution = FMLEnvironment.dist;

    public SidedDependencyServiceLoader(Class<T> service, java.util.function.Supplier<@NotNull T> physicalSideFallbackFactory) {
        super(SidedDependencyServiceLoader.supplier(service, physicalSideFallbackFactory, FMLEnvironment.dist));
    }

    public Dist getSide() {
        return this._distribution;
    }

    private static <T> Supplier<@NotNull T> supplier(Class<T> service, java.util.function.Supplier<@NotNull T> physicalSideFallbackFactory, Dist distribution) {
        Preconditions.checkNotNull(physicalSideFallbackFactory, (Object)"Physical side fallback factory must not be null");
        if (distribution.isClient()) {
            return SidedDependencyServiceLoader.loadOrFail(service);
        }
        return physicalSideFallbackFactory::get;
    }
}

