/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.lib.network.AbstractPlayPacket;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public class InternalCommandMessage
extends AbstractPlayPacket<InternalCommandMessage> {
    public static final CustomPacketPayload.Type<InternalCommandMessage> TYPE = InternalCommandMessage.createType(ZeroCore.ROOT_LOCATION, "internal_command");
    public static final StreamCodec<FriendlyByteBuf, InternalCommandMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(InternalCommand.class), packet -> packet._command, (StreamCodec)ByteBufCodecs.OPTIONAL_COMPOUND_TAG, packet -> Optional.ofNullable(packet._data), InternalCommandMessage::new);
    private final InternalCommand _command;
    @Nullable
    private final CompoundTag _data;

    public InternalCommandMessage(InternalCommand command, CompoundTag data) {
        super(TYPE);
        Preconditions.checkNotNull((Object)((Object)command), (Object)"Command must not be null");
        Preconditions.checkNotNull((Object)data, (Object)"Data must not be null");
        this._command = command;
        this._data = data;
    }

    public InternalCommandMessage(InternalCommand command) {
        super(TYPE);
        Preconditions.checkNotNull((Object)((Object)command), (Object)"Command must not be null");
        this._command = command;
        this._data = null;
    }

    @Override
    public void handlePacket(IPayloadContext context) {
        ZeroCore.getProxy().handleInternalCommand(this._command, null == this._data ? new CompoundTag() : this._data, context.flow());
    }

    private InternalCommandMessage(InternalCommand command, Optional<CompoundTag> data) {
        super(TYPE);
        Preconditions.checkNotNull((Object)((Object)command), (Object)"Command must not be null");
        this._command = command;
        this._data = data.orElse(null);
    }
}

