/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor;

import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.ISensorBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanel;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanelBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorsList;
import it.zerono.mods.zerocore.base.redstone.sensor.AbstractSensorSetting;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorSettingFactory;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.FlowLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SensorPanel<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>>
extends Panel {
    private static final int VERTICAL_MARGIN = 4;
    private final ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> _sensorSettingFactory;
    private final SensorsList<Reader, Writer, SensorType, SensorSetting> _sensorsList;
    private final SensorGroupPanel<Reader, Writer, SensorType, SensorSetting> _sensorsGroup;
    private final Button _saveButton;
    private final Button _resetButton;

    @SafeVarargs
    public SensorPanel(ModContainerScreen<? extends ModContainer> gui, IBindableData<SensorSetting> bindableSettings, int sensorsListColumns, String sensorsListLabelKey, int width, int height, Consumer<@NotNull ISensorBuilder<Reader, SensorType>> sensorBuilder, Runnable onSave, Runnable onDisable, SensorSetting resetToSettings, ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> sensorSettingFactory, SensorType ... validSensors) {
        super(gui, "sensorPanel");
        this._sensorSettingFactory = sensorSettingFactory;
        bindableSettings.bind(this::setSettings);
        this.setDesiredDimension(width, height);
        this.setLayoutEngine((ILayoutEngine)((FlowLayoutEngine)((FlowLayoutEngine)((FlowLayoutEngine)new FlowLayoutEngine().setZeroMargins()).setVerticalMargin(4)).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        int sensorsListWidth = SensorsList.computeWidth(sensorsListColumns);
        int sensorsGroupWidth = width - sensorsListWidth;
        SensorGroupPanelBuilder builder = new SensorGroupPanelBuilder(gui, sensorsGroupWidth, height - 16 - 8, validSensors);
        sensorBuilder.accept(builder);
        this._sensorsGroup = new SensorGroupPanel(builder);
        this._sensorsList = new SensorsList(builder, sensorsListColumns, sensorsListLabelKey, x$0 -> this.onSensorChanged((Enum)x$0));
        this.addControl(this._sensorsList, this._sensorsGroup);
        Panel buttonsPanel = new Panel(this.getGui());
        buttonsPanel.setDesiredDimension(width, 16);
        buttonsPanel.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine().setZeroMargins());
        this.addControl((IControl)buttonsPanel);
        int buttonWidth = 55;
        int buttonX = width - 55;
        this._resetButton = new Button(gui, "reset", (Component)TextHelper.translatable("gui.zerocore.base.generic.reset"));
        this._resetButton.Clicked.subscribe(($1, $2) -> this.setSettings(resetToSettings));
        this._resetButton.setLayoutEngineHint(FixedLayoutEngine.hint(buttonX, 0, 55, 16));
        buttonsPanel.addControl((IControl)this._resetButton);
        this._saveButton = new Button(gui, "save", (Component)TextHelper.translatable("gui.zerocore.base.generic.save"));
        this._saveButton.Clicked.subscribe(($1, $2) -> onSave.run());
        this._saveButton.setLayoutEngineHint(FixedLayoutEngine.hint(buttonX -= 57, 0, 55, 16));
        buttonsPanel.addControl((IControl)this._saveButton);
        Button disableButton = new Button(gui, "disable", (Component)TextHelper.translatable("gui.zerocore.base.generic.disable"));
        disableButton.Clicked.subscribe(($1, $2) -> onDisable.run());
        disableButton.setLayoutEngineHint(FixedLayoutEngine.hint(0, 0, sensorsListWidth, 16));
        buttonsPanel.addControl((IControl)disableButton);
    }

    public SensorSetting getSettings(SensorSetting defaultValue) {
        return this._sensorsGroup.getSettings(this._sensorSettingFactory, defaultValue);
    }

    public void setSettings(SensorSetting setting) {
        this.resetSettings();
        if (!((ISensorType)((AbstractSensorSetting)setting).Sensor).isDisabled()) {
            this._sensorsList.setSettings(setting);
            this._sensorsGroup.setSettings(setting);
        }
    }

    private void onSensorChanged(SensorType sensor) {
        boolean sensorDisabled = ((ISensorType)sensor).isDisabled();
        this._saveButton.setVisible(!sensorDisabled);
        this._resetButton.setVisible(!sensorDisabled);
        this._sensorsGroup.setActiveSensor(sensor);
    }

    private void resetSettings() {
        this._sensorsList.resetSettings();
        this._sensorsGroup.resetControls();
    }
}

