/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.offline;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.offline.AdvancementProgressAccessor;
import io.wispforest.owo.offline.DataSavedEvents;
import io.wispforest.owo.offline.OfflineAdvancementState;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public final class OfflineAdvancementLookup {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Codec<Map<ResourceLocation, AdvancementProgress>> CODEC = DataFixTypes.ADVANCEMENTS.wrapCodec((Codec)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)AdvancementProgress.CODEC), DataFixers.getDataFixer(), 1343);

    private OfflineAdvancementLookup() {
    }

    public static void put(UUID player, Map<ResourceLocation, AdvancementProgress> map) {
        ((DataSavedEvents.Advancements)DataSavedEvents.ADVANCEMENTS.invoker()).onSaved(player, map);
        try {
            Path advancementsPath = Owo.currentServer().getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR);
            Path advancementPath = advancementsPath.resolve(player.toString() + ".json");
            JsonElement saved = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, map).getOrThrow(IllegalStateException::new);
            try (BufferedWriter bw = Files.newBufferedWriter(advancementPath, new OpenOption[0]);){
                GSON.toJson(saved, (Appendable)bw);
            }
        }
        catch (IOException e) {
            Owo.LOGGER.error("Couldn't save advancements of offline player {}", (Object)player, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Map<ResourceLocation, AdvancementProgress> get(UUID player) {
        try {
            Map parsedMap;
            Path advancementsPath = Owo.currentServer().getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR);
            if (!Files.exists(advancementsPath, new LinkOption[0])) {
                return null;
            }
            Path advancementFile = advancementsPath.resolve(String.valueOf(player) + ".json");
            if (!Files.exists(advancementFile, new LinkOption[0])) {
                return null;
            }
            try (InputStream s = Files.newInputStream(advancementFile, new OpenOption[0]);
                 InputStreamReader streamReader = new InputStreamReader(s);
                 JsonReader reader = new JsonReader((Reader)streamReader);){
                reader.setLenient(false);
                JsonElement jsonElement = Streams.parse((JsonReader)reader);
                parsedMap = (Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonParseException::new);
            }
            for (Map.Entry entry : parsedMap.entrySet()) {
                AdvancementHolder adv;
                AdvancementRequirements requirements = ((AdvancementProgressAccessor)entry.getValue()).getRequirements();
                if (requirements.size() != 0 || (adv = Owo.currentServer().getAdvancements().get((ResourceLocation)entry.getKey())) == null) continue;
                ((AdvancementProgressAccessor)entry.getValue()).setRequirements(adv.value().requirements());
            }
            return parsedMap;
        }
        catch (IOException e) {
            Owo.LOGGER.error("Couldn't get advancements for offline player {}", (Object)player, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void edit(UUID player, Consumer<OfflineAdvancementState> editor) {
        Map<ResourceLocation, AdvancementProgress> advancementData = OfflineAdvancementLookup.get(player);
        if (advancementData == null) {
            advancementData = new HashMap<ResourceLocation, AdvancementProgress>();
        }
        OfflineAdvancementState transaction = new OfflineAdvancementState(advancementData);
        editor.accept(transaction);
        OfflineAdvancementLookup.put(player, transaction.advancementData());
    }

    public static List<UUID> savedPlayers() {
        Path advancementsPath = Owo.currentServer().getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR);
        if (!Files.isDirectory(advancementsPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<UUID> list = new ArrayList<UUID>();
        try {
            Iterator iterator = Files.list(advancementsPath).iterator();
            while (iterator.hasNext()) {
                Path savedPlayerFile = (Path)iterator.next();
                if (Files.isDirectory(savedPlayerFile, new LinkOption[0]) || !savedPlayerFile.toString().endsWith(".json")) continue;
                try {
                    String filename = savedPlayerFile.getFileName().toString();
                    String uuidStr = filename.substring(0, filename.lastIndexOf(46));
                    UUID uuid = UUID.fromString(uuidStr);
                    list.add(uuid);
                }
                catch (IllegalArgumentException iae) {
                    Owo.LOGGER.error("Encountered invalid UUID in advancements directory", (Throwable)iae);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }
}

