/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.newctm;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.newctm.CustomCTMLogic;
import team.chisel.ctm.client.newctm.LocalDirection;
import team.chisel.ctm.client.util.Submap;

public class CTMLogicBakery {
    private int size;
    private final Int2ObjectMap<LocalDirection> bitmap = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<OutputFace> outputs = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<DesiredState> rules = new Int2ObjectOpenHashMap();
    private int curRule = -1;

    public CTMLogicBakery input(int bit, LocalDirection dir) {
        this.bitmap.put(bit, (Object)dir);
        if (bit >= this.size) {
            this.size = bit + 1;
        }
        return this;
    }

    public CTMLogicBakery output(int submap, ISubmap texture) {
        return this.output(submap, texture, Submap.X1);
    }

    public CTMLogicBakery output(int submap, int textureId, ISubmap texture) {
        return this.output(submap, textureId, texture, Submap.X1);
    }

    public CTMLogicBakery output(int submap, ISubmap texture, ISubmap at) {
        return this.output(submap, 0, texture, at);
    }

    public CTMLogicBakery output(int submap, int textureId, ISubmap texture, ISubmap at) {
        this.curRule = submap;
        this.outputs.put(submap, (Object)new OutputFace(textureId, texture, at));
        return this;
    }

    public CTMLogicBakery at(int submap, ISubmap at) {
        OutputFace existing = (OutputFace)this.outputs.get(submap);
        if (existing == null) {
            throw new IllegalArgumentException("Unknown submap ID " + submap);
        }
        return this.output(submap, existing.uvs, at);
    }

    public CTMLogicBakery when(int rule, int bit, boolean is) {
        this.curRule = rule;
        return this.when(bit, is);
    }

    public CTMLogicBakery when(int bit, boolean is) {
        Preconditions.checkArgument((bit < this.size ? 1 : 0) != 0, (Object)"bit out of range");
        this.rules.putIfAbsent(this.curRule, (Object)new DesiredState(this.size, this.curRule));
        this.rules.compute(this.curRule, (i, s) -> s.with(bit, is ? Trinary.TRUE : Trinary.FALSE));
        return this;
    }

    public CTMLogicBakery when(String pattern) {
        Preconditions.checkArgument((pattern.length() == this.size ? 1 : 0) != 0, (Object)"pattern length");
        for (int i = pattern.length() - 1; i >= 0; --i) {
            char bit = pattern.charAt(i);
            if (bit != '0' && bit != '1') continue;
            this.when(pattern.length() - 1 - i, bit == '1');
        }
        return this;
    }

    public CustomCTMLogic bake() {
        int max = 1 << this.size;
        int[][] lookups = new int[max][];
        for (int state = 0; state < max; ++state) {
            for (Int2ObjectMap.Entry e : this.rules.int2ObjectEntrySet()) {
                if (!((DesiredState)e.getValue()).test(state)) continue;
                if (lookups[state] == null) {
                    lookups[state] = new int[]{e.getIntKey()};
                    continue;
                }
                lookups[state] = ArrayUtils.add((int[])lookups[state], (int)e.getIntKey());
            }
        }
        return new CustomCTMLogic(lookups, this.asSortedArray(this.outputs, OutputFace[]::new), this.asSortedArray(this.bitmap, LocalDirection[]::new));
    }

    private <T> T[] asSortedArray(Int2ObjectMap<T> indexedMap, IntFunction<T[]> ctor) {
        return indexedMap.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).map(Map.Entry::getValue).toArray(ctor);
    }

    public String asJsonExample() {
        StringWriter buf = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)buf);
        writer.setIndent("  ");
        writer.beginObject();
        LocalDirection[] orderedPositions = this.asSortedArray(this.bitmap, LocalDirection[]::new);
        writer.name("positions");
        writer.beginArray();
        for (LocalDirection dir : orderedPositions) {
            writer.jsonValue(dir.asJson());
        }
        writer.endArray();
        writer.name("submaps");
        writer.beginObject();
        writer.name("type").value("grid");
        writer.name("width").value(12L);
        writer.name("height").value(4L);
        writer.endObject();
        writer.name("rules");
        writer.beginArray();
        for (Int2ObjectMap.Entry e : this.rules.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).toList()) {
            writer.jsonValue(((DesiredState)e.getValue()).asJson(orderedPositions));
        }
        writer.endArray();
        writer.endObject();
        writer.flush();
        writer.close();
        return buf.toString();
    }

    public record OutputFace(int tex, ISubmap uvs, ISubmap face) {
    }

    private static final class DesiredState {
        private final Trinary[] input;
        private final int output;

        public DesiredState(int size, int output) {
            this.input = new Trinary[size];
            Arrays.fill((Object[])this.input, (Object)Trinary.DONT_CARE);
            this.output = output;
        }

        public DesiredState with(int bit, Trinary in) {
            this.input[bit] = in;
            return this;
        }

        public boolean test(int state) {
            for (int i = 0; i < this.input.length; ++i) {
                boolean bit;
                Trinary req = this.input[i];
                boolean bl = bit = (state >> i & 1) == 1;
                if (req == Trinary.DONT_CARE || bit == req.val) continue;
                return false;
            }
            return true;
        }

        public String asJson(LocalDirection[] values) {
            StringWriter buf = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)buf);
            writer.beginObject();
            writer.name("output").value((long)this.output);
            ArrayList<LocalDirection> connected = new ArrayList<LocalDirection>();
            ArrayList<LocalDirection> unconnected = new ArrayList<LocalDirection>();
            for (int i = 0; i < this.input.length; ++i) {
                if (this.input[i] == Trinary.TRUE) {
                    connected.add(values[this.input.length - 1 - i]);
                    continue;
                }
                if (this.input[i] != Trinary.FALSE) continue;
                unconnected.add(values[this.input.length - 1 - i]);
            }
            writer.name("connected");
            writer.beginArray();
            for (LocalDirection d : connected) {
                writer.value(d.name());
            }
            writer.endArray();
            writer.name("unconnected");
            writer.beginArray();
            for (LocalDirection d : unconnected) {
                writer.value(d.name());
            }
            writer.endArray();
            writer.endObject();
            writer.flush();
            writer.close();
            return buf.toString();
        }

        public Trinary[] getInput() {
            return this.input;
        }

        public int getOutput() {
            return this.output;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DesiredState)) {
                return false;
            }
            DesiredState other = (DesiredState)o;
            if (this.getOutput() != other.getOutput()) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.getInput(), (Object[])other.getInput());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOutput();
            result = result * 59 + Arrays.deepHashCode((Object[])this.getInput());
            return result;
        }

        public String toString() {
            return "CTMLogicBakery.DesiredState(input=" + Arrays.deepToString((Object[])this.getInput()) + ", output=" + this.getOutput() + ")";
        }
    }

    private static enum Trinary {
        FALSE(false, 0),
        TRUE(true, 1),
        DONT_CARE(false, 0);

        public final boolean val;
        public final int bit;

        private Trinary(boolean val, int bit) {
            this.val = val;
            this.bit = bit;
        }
    }
}

