/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.ModelUtil;
import team.chisel.ctm.client.util.ProfileUtil;

public abstract class AbstractCTMBakedModel
extends BakedModelWrapper<BakedModel> {
    private static final Cache<ModelResourceLocation, AbstractCTMBakedModel> itemcache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static final Cache<State, AbstractCTMBakedModel> modelcache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build();
    @NotNull
    private final IModelCTM model;
    @NotNull
    private final Overrides overrides = new Overrides();
    @Nullable
    private final RenderType layer;
    protected final List<BakedQuad> genQuads = new ArrayList<BakedQuad>();
    protected final ListMultimap<Direction, BakedQuad> faceQuads = ArrayListMultimap.create();
    public static final ModelProperty<RenderContextList> CTM_CONTEXT = new ModelProperty();

    public static void invalidateCaches() {
        itemcache.invalidateAll();
        modelcache.invalidateAll();
    }

    public AbstractCTMBakedModel(@NotNull IModelCTM model, BakedModel parent, @Nullable RenderType layer) {
        super(parent);
        this.model = model;
        this.layer = layer;
    }

    @NotNull
    public final List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, this.layer);
    }

    public final List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType layer) {
        AbstractCTMBakedModel baked;
        ProfileUtil.start("ctm_models");
        BakedModel parent = this.getParent(rand);
        try {
            if (state == null) {
                return this.quadLookup(side, layer);
            }
            RenderContextList ctmCtx = (RenderContextList)extraData.get(CTM_CONTEXT);
            Object2LongMap<ICTMTexture<?>> serialized = ctmCtx == null ? null : ctmCtx.serialized();
            ProfileUtil.start("model_creation");
            baked = (AbstractCTMBakedModel)((Object)modelcache.get((Object)new State(state, serialized, parent, layer), () -> this.createModel(state, this.model, parent, ctmCtx, rand, extraData, layer)));
            ProfileUtil.end();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        List<BakedQuad> quads = baked.quadLookup(side, layer);
        return quads;
    }

    protected final List<BakedQuad> quadLookup(@Nullable Direction side, @Nullable RenderType layer) {
        ProfileUtil.start("quad_lookup");
        List<Object> ret = Collections.emptyList();
        if (layer == this.layer) {
            ret = side != null ? this.faceQuads.get((Object)side) : this.genQuads;
        }
        ProfileUtil.end();
        ProfileUtil.end();
        if (ret == null) {
            throw new IllegalStateException("getQuads called on a model that was not properly initialized - by using getOverrides and/or getModelData");
        }
        return ret;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        ChunkRenderTypeSet extraTypes = this.layer != null ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.layer}) : ChunkRenderTypeSet.of(this.getModel().getExtraLayers(state));
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{extraTypes, super.getRenderTypes(state, rand, data)});
    }

    public List<RenderType> getRenderTypes(@NotNull ItemStack itemStack, boolean fabulous) {
        ArrayList<RenderType> ret = new ArrayList<RenderType>(super.getRenderTypes(itemStack, fabulous));
        if (this.layer != null) {
            if (!ret.contains(this.layer)) {
                ret.add(this.layer);
            }
        } else {
            RenderType type = RenderTypeHelper.getFallbackItemRenderType((ItemStack)itemStack, (BakedModel)this, (boolean)false);
            if (!ret.contains(type)) {
                ret.add(type);
            }
        }
        return ret;
    }

    public BakedModel applyTransform(@NotNull ItemDisplayContext displayContext, @NotNull PoseStack mat, boolean applyLeftHandTransform) {
        super.applyTransform(displayContext, mat, applyLeftHandTransform);
        return this;
    }

    public List<BakedModel> getRenderPasses(@NotNull ItemStack stack, boolean fabulous) {
        return List.of(this);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (!(tileData = super.getModelData(world, pos, state, tileData)).has(CTM_CONTEXT)) {
            ProfileUtil.start("ctm_state_creation");
            RenderContextList ctmCtx = new RenderContextList(state, this.getCTMTextures(), world, pos);
            ProfileUtil.end();
            tileData = tileData.derive().with(CTM_CONTEXT, (Object)ctmCtx).build();
        }
        return tileData;
    }

    @NotNull
    public BakedModel getParent(RandomSource rand) {
        BakedModel bakedModel = this.getParent();
        if (bakedModel instanceof WeightedBakedModel) {
            WeightedBakedModel weightedBakedModel = (WeightedBakedModel)bakedModel;
            Optional model = WeightedRandom.getWeightedItem((List)weightedBakedModel.list, (int)(Math.abs((int)rand.nextLong()) % weightedBakedModel.totalWeight));
            if (model.isPresent()) {
                return (BakedModel)((WeightedEntry.Wrapper)model.get()).data();
            }
        }
        return this.getParent();
    }

    @NotNull
    public BakedModel getParent() {
        return this.originalModel;
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    protected abstract AbstractCTMBakedModel createModel(BlockState var1, @NotNull IModelCTM var2, BakedModel var3, RenderContextList var4, RandomSource var5, ModelData var6, @Nullable RenderType var7);

    @Nullable
    private <T> T applyToParent(RandomSource rand, Function<AbstractCTMBakedModel, T> func) {
        BakedModel parent = this.getParent(rand);
        if (parent instanceof AbstractCTMBakedModel) {
            AbstractCTMBakedModel ctmBakedModel = (AbstractCTMBakedModel)parent;
            return func.apply(ctmBakedModel);
        }
        return null;
    }

    @Nullable
    protected ICTMTexture<?> getOverrideTexture(RandomSource rand, int tintIndex, ResourceLocation texture) {
        ICTMTexture ret = this.getModel().getOverrideTexture(tintIndex, texture);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideTexture(rand, tintIndex, texture));
        }
        return ret;
    }

    @Nullable
    protected ICTMTexture<?> getTexture(RandomSource rand, ResourceLocation texture) {
        ICTMTexture ret = this.getModel().getTexture(texture);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getTexture(rand, texture));
        }
        return ret;
    }

    @Nullable
    protected TextureAtlasSprite getOverrideSprite(RandomSource rand, int tintIndex) {
        TextureAtlasSprite ret = this.getModel().getOverrideSprite(tintIndex);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideSprite(rand, tintIndex));
        }
        return ret;
    }

    public Collection<ICTMTexture<?>> getCTMTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.getModel().getCTMTextures());
        BakedModel bakedModel = this.getParent();
        if (bakedModel instanceof AbstractCTMBakedModel) {
            AbstractCTMBakedModel ctmBakedModel = (AbstractCTMBakedModel)bakedModel;
            builder.addAll(ctmBakedModel.getCTMTextures());
        }
        return builder.build();
    }

    @NotNull
    public IModelCTM getModel() {
        return this.model;
    }

    @ParametersAreNonnullByDefault
    private class Overrides
    extends ItemOverrides {
        public BakedModel resolve(BakedModel originalModel, ItemStack stack, ClientLevel world, LivingEntity entity, int unknown) {
            ModelResourceLocation mrl = ModelUtil.getMesh(stack);
            if (mrl == ModelBakery.MISSING_MODEL_VARIANT) {
                return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getModelManager().getMissingModel();
            }
            Block block = null;
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.getBlock();
            }
            BlockState state = block == null ? null : block.defaultBlockState();
            RandomSource random = RandomSource.create();
            random.setSeed(42L);
            return (BakedModel)itemcache.get((Object)mrl, () -> AbstractCTMBakedModel.this.createModel(state, AbstractCTMBakedModel.this.model, AbstractCTMBakedModel.this.getParent(random), null, random, ModelData.EMPTY, null));
        }
    }

    private record State(@NotNull BlockState cleanState, @Nullable Object2LongMap<ICTMTexture<?>> serializedContext, @NotNull BakedModel parent, @Nullable RenderType layer) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            return this.cleanState == other.cleanState && this.parent == other.parent && this.layer == other.layer && Objects.equals(this.serializedContext, other.serializedContext);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.cleanState);
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.serializedContext == null ? 0 : this.serializedContext.hashCode());
            result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
            return result;
        }
    }
}

