/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContext;

public final class LatestLogLocator {
    private LatestLogLocator() {
    }

    public static Path findLatestLogPath() {
        LoggerContext ctx = LogManager.getContext((boolean)false);
        if (ctx == null) {
            return null;
        }
        try {
            Method getConfigurationMethod = ctx.getClass().getMethod("getConfiguration", new Class[0]);
            Object config = getConfigurationMethod.invoke((Object)ctx, new Object[0]);
            if (config == null) {
                return null;
            }
            Method getAppendersMethod = config.getClass().getMethod("getAppenders", new Class[0]);
            Object appendersObj = getAppendersMethod.invoke(config, new Object[0]);
            if (!(appendersObj instanceof Map)) {
                return null;
            }
            Map appenders = (Map)appendersObj;
            Path suffix = Paths.get("logs", "latest.log");
            for (Map.Entry entryObj : appenders.entrySet()) {
                Path abs;
                String fileName;
                Map.Entry entry;
                Object appender;
                if (!(entryObj instanceof Map.Entry) || (appender = (entry = entryObj).getValue()) == null || (fileName = LatestLogLocator.tryGetFileName(appender)) == null || fileName.isEmpty() || !(abs = Paths.get(fileName, new String[0]).toAbsolutePath().normalize()).endsWith(suffix) || !Files.isRegularFile(abs, new LinkOption[0])) continue;
                return abs;
            }
        }
        catch (NoSuchMethodException e) {}
        catch (IllegalAccessException e) {}
        catch (InvocationTargetException e) {}
        finally {
            return null;
        }
        {
        }
    }

    private static String tryGetFileName(Object appender) {
        try {
            Method getFileNameMethod = appender.getClass().getMethod("getFileName", new Class[0]);
            Object value = getFileNameMethod.invoke(appender, new Object[0]);
            if (value instanceof String) {
                return (String)value;
            }
        }
        catch (NoSuchMethodException e) {}
        catch (IllegalAccessException e) {}
        catch (InvocationTargetException e) {}
        finally {
            return null;
        }
        {
        }
    }
}

