/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class UpdatedPair {
    private final LinkedHashSet<Mod> oldMods;
    private final LinkedHashSet<Mod> newMods;

    public UpdatedPair(LinkedHashSet<Mod> oldMods, LinkedHashSet<Mod> newMods) {
        this.oldMods = oldMods;
        this.newMods = newMods;
    }

    public LinkedHashSet<Mod> getOldMods() {
        return this.oldMods;
    }

    public LinkedHashSet<Mod> getNewMods() {
        return this.newMods;
    }

    public boolean oldModsEqualsNewMods() {
        if (this.oldMods.equals(this.newMods)) {
            return true;
        }
        if (this.oldMods.size() == this.newMods.size() && this.oldMods.size() == 1) {
            return ((Mod)this.oldMods.iterator().next()).getJarName().equalsIgnoreCase(((Mod)this.newMods.iterator().next()).getJarName());
        }
        return false;
    }

    public String getModId() {
        return ((Mod)this.oldMods.iterator().next()).getModId();
    }

    public boolean isAnyModMessedUpWithVersion() {
        block5: {
            String version;
            HashMap<String, HashSet> versionToJarNames = new HashMap<String, HashSet>();
            for (Mod mod : this.oldMods) {
                version = mod.getVersion();
                if (version != null && !version.isEmpty()) {
                    versionToJarNames.computeIfAbsent(version, k -> new HashSet()).add(mod.getJarName());
                    continue;
                }
                break block5;
            }
            for (Mod mod : this.newMods) {
                version = mod.getVersion();
                if (version != null && !version.isEmpty()) {
                    versionToJarNames.computeIfAbsent(version, k -> new HashSet()).add(mod.getJarName());
                    continue;
                }
                break block5;
            }
            for (Map.Entry entry : versionToJarNames.entrySet()) {
                HashSet jarNames = (HashSet)entry.getValue();
                if (jarNames.size() < 2) continue;
                return true;
            }
        }
        return this.oldMods.stream().anyMatch(Mod::isModMessedUpWithVersion) || this.newMods.stream().anyMatch(Mod::isModMessedUpWithVersion);
    }
}

