/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object;

import com.iafenvoy.uranus.object.VecUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityUtil {
    public static <M extends Mob> void summon(EntityType<M> entityType, ServerLevel world, double x, double y, double z) {
        Mob entityToSpawn = (Mob)entityType.create((Level)world);
        if (entityToSpawn != null) {
            entityToSpawn.moveTo(x, y, z, world.getRandom().nextFloat() * 360.0f, 0.0f);
            entityToSpawn.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(entityToSpawn.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            world.addFreshEntity((Entity)entityToSpawn);
        }
    }

    public static void lightening(ServerLevel world, double x, double y, double z) {
        EntityUtil.lightening(world, x, y, z, true);
    }

    public static void lightening(ServerLevel world, double x, double y, double z, boolean cosmetic) {
        LightningBolt entityToSpawn = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
        if (entityToSpawn != null) {
            entityToSpawn.moveTo(VecUtil.createBottomCenter(x, y, z));
            entityToSpawn.setVisualOnly(cosmetic);
            world.addFreshEntity((Entity)entityToSpawn);
        }
    }

    public static void item(ServerLevel world, double x, double y, double z, ItemLike item, int pickUpDelay) {
        EntityUtil.item(world, x, y, z, new ItemStack(item), pickUpDelay);
    }

    public static void item(ServerLevel world, double x, double y, double z, ItemStack item, int pickUpDelay) {
        ItemEntity entityToSpawn = new ItemEntity((Level)world, x, y + 1.0, z, item);
        entityToSpawn.setPickUpDelay(pickUpDelay);
        world.addFreshEntity((Entity)entityToSpawn);
    }
}

