/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface IArmorRendererBase<T extends LivingEntity> {
    public static final HashMap<ItemLike, IArmorRendererBase<? extends LivingEntity>> RENDERERS = new HashMap();

    public HumanoidModel<T> getHumanoidArmorModel(LivingEntity var1, ItemStack var2, EquipmentSlot var3, HumanoidModel<T> var4);

    public ResourceLocation getArmorTexture(ItemStack var1, Entity var2, EquipmentSlot var3);

    default public void render(PoseStack matrices, MultiBufferSource vertexConsumers, LivingEntity entity, EquipmentSlot slot, int light, ItemStack stack, HumanoidModel<T> defaultModel) {
        HumanoidModel<T> armorModel = this.getHumanoidArmorModel(entity, stack, slot, defaultModel);
        defaultModel.copyPropertiesTo(armorModel);
        armorModel.head.visible = slot == EquipmentSlot.HEAD;
        armorModel.hat.visible = slot == EquipmentSlot.HEAD;
        armorModel.body.visible = slot == EquipmentSlot.CHEST;
        armorModel.leftArm.visible = slot == EquipmentSlot.CHEST;
        armorModel.rightArm.visible = slot == EquipmentSlot.CHEST;
        armorModel.leftLeg.visible = slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
        armorModel.rightLeg.visible = slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
        VertexConsumer consumer = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)this.getArmorTexture(stack, (Entity)entity, slot)));
        armorModel.renderToBuffer(matrices, consumer, light, OverlayTexture.NO_OVERLAY, -1);
    }

    public static <T extends LivingEntity> void register(IArmorRendererBase<T> renderer, ItemLike ... items) {
        Arrays.stream(items).forEach(x -> RENDERERS.put((ItemLike)x, renderer));
    }
}

