/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.QuestBarrierBlock;
import dev.ftb.mods.ftbquests.block.entity.EditableBlockEntity;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.net.BlockConfigResponseMessage;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBarrierBlockEntity
extends EditableBlockEntity {
    protected String objStr = "";
    protected BlockState camo = null;
    private boolean invisibleWhenOpen = false;
    private ItemStack skin = ItemStack.EMPTY;
    private TeleportData teleportData = TeleportData.NONE;

    public BaseBarrierBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity instanceof BaseBarrierBlockEntity) {
            boolean completed;
            BaseBarrierBlockEntity barrier = (BaseBarrierBlockEntity)blockEntity;
            if (level.isClientSide && FTBQuestsClient.isClientDataLoaded() && level.getGameTime() % 5L == 0L && (completed = barrier.isOpen(FTBQuestsClient.getClientPlayer())) != (Boolean)blockState.getValue((Property)QuestBarrierBlock.OPEN)) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(completed)), 10);
                blockEntity.setChanged();
                barrier.forceAppearanceUpdate();
            }
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Object")) {
            this.objStr = tag.getString("Object");
            this.skin = ItemStack.EMPTY;
        } else {
            BarrierSavedData data = BarrierSavedData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("savedData")).result().orElse(BarrierSavedData.DEFAULT);
            this.applySavedData(data);
        }
    }

    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        BarrierSavedData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)BarrierSavedData.fromBlockEntity(this)).ifSuccess(tag -> compoundTag.put("savedData", tag));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput dataComponentInput) {
        super.applyImplicitComponents(dataComponentInput);
        this.applySavedData((BarrierSavedData)dataComponentInput.getOrDefault((DataComponentType)ModDataComponents.BARRIER_SAVED.get(), (Object)BarrierSavedData.DEFAULT));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)ModDataComponents.BARRIER_SAVED.get(), (Object)BarrierSavedData.fromBlockEntity(this));
    }

    protected void applySavedData(BarrierSavedData data) {
        this.objStr = data.objStr;
        this.setSkin(data.skin);
        this.setInvisibleWhenOpen(data.invisibleWhenOpen);
        this.teleportData = data.teleportData.orElse(TeleportData.NONE);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void setChanged() {
        if (this.level instanceof ServerLevel) {
            this.level.blockEntityChanged(this.getBlockPos());
        }
    }

    public void updateFromString(String objStr) {
        this.objStr = objStr;
        this.setChanged();
    }

    public abstract boolean isOpen(Player var1);

    protected abstract void addConfigEntries(ConfigGroup var1);

    public ConfigGroup fillConfigGroup() {
        ConfigGroup group = new ConfigGroup("ftbquests.barrier", accepted -> {
            if (accepted) {
                NetworkManager.sendToServer((CustomPacketPayload)new BlockConfigResponseMessage(this.getBlockPos(), this.saveWithoutMetadata((HolderLookup.Provider)this.getLevel().registryAccess())));
            }
        });
        group.setNameKey(this.getBlockState().getBlock().getDescriptionId());
        this.addConfigEntries(group);
        if (Platform.isForgeLike()) {
            ConfigGroup appearance = group.getOrCreateSubgroup("appearance").setNameKey("ftbquests.quest.appearance");
            ((ItemStackConfig)appearance.add("skin", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getSkin(), this::setSkin, (Object)ItemStack.EMPTY)).withFilter(stack -> stack.getItem() instanceof BlockItem).setNameKey("block.ftbquests.screen.skin");
            appearance.addBool("invis_when_open", this.isInvisibleWhenOpen(), this::setInvisibleWhenOpen, false).setNameKey("block.ftbquests.barrier.invis_when_open");
        }
        ConfigGroup teleport = group.getOrCreateSubgroup("teleport").setNameKey("ftbquests.barrier.teleport");
        teleport.addBool("enabled", this.teleportData.enabled, v -> {
            this.teleportData = this.teleportData.withEnabled((boolean)v);
        }, false);
        teleport.addBool("relative", this.teleportData.relative, v -> {
            this.teleportData = this.teleportData.withRelative((boolean)v);
        }, false);
        teleport.addInt("dest_x", this.teleportData.dest.getX(), v -> {
            this.teleportData = this.teleportData.withDestX((int)v);
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        teleport.addInt("dest_y", this.teleportData.dest.getY(), v -> {
            this.teleportData = this.teleportData.withDestY((int)v);
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        teleport.addInt("dest_z", this.teleportData.dest.getZ(), v -> {
            this.teleportData = this.teleportData.withDestZ((int)v);
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        teleport.addDouble("pitch", (double)this.teleportData.pitch, v -> {
            this.teleportData = this.teleportData.withPitch(v.floatValue());
        }, 0.0, -90.0, 90.0);
        teleport.addDouble("yaw", (double)this.teleportData.yaw, v -> {
            this.teleportData = this.teleportData.withYaw(v.floatValue());
        }, 0.0, 0.0, 360.0);
        teleport.addString("dimension", this.teleportData.dimStr(), v -> {
            this.teleportData = this.teleportData.withDimId((String)v);
        }, "");
        return group;
    }

    public ItemStack getSkin() {
        return this.skin;
    }

    public void setSkin(ItemStack skin) {
        this.skin = skin;
        this.forceAppearanceUpdate();
        this.setChanged();
    }

    public boolean isInvisibleWhenOpen() {
        return this.invisibleWhenOpen;
    }

    public void setInvisibleWhenOpen(boolean invisibleWhenOpen) {
        this.invisibleWhenOpen = invisibleWhenOpen;
        this.forceAppearanceUpdate();
        this.setChanged();
    }

    public void forceAppearanceUpdate() {
        this.camo = null;
    }

    public BlockState getClientAppearance() {
        if (this.camo == null) {
            if (this.isOpen(FTBQuestsClient.getClientPlayer())) {
                this.camo = this.invisibleWhenOpen ? Blocks.AIR.defaultBlockState() : (BlockState)((Block)ModBlocks.BARRIER.get()).defaultBlockState().setValue((Property)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(true));
            } else {
                BlockState blockState;
                Item item = this.skin.getItem();
                if (item instanceof BlockItem) {
                    BlockItem bi = (BlockItem)item;
                    blockState = bi.getBlock().defaultBlockState();
                } else {
                    blockState = (BlockState)((Block)ModBlocks.BARRIER.get()).defaultBlockState().setValue((Property)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(false));
                }
                this.camo = blockState;
            }
        }
        return this.camo;
    }

    @Override
    public boolean hasPermissionToEdit(Player player) {
        return FTBQuestsAPI.api().getQuestFile(this.level.isClientSide).getTeamData(player).map(team -> team.getCanEdit(player)).orElse(false);
    }

    public Optional<TeleportData> optionalTeleportData() {
        return this.teleportData.equals(TeleportData.NONE) ? Optional.empty() : Optional.of(this.teleportData);
    }

    public record TeleportData(boolean enabled, boolean relative, BlockPos dest, float pitch, float yaw, Optional<ResourceKey<Level>> dimId) {
        public static final Codec<TeleportData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)false).forGetter(TeleportData::enabled), (App)Codec.BOOL.optionalFieldOf("relative", (Object)false).forGetter(TeleportData::relative), (App)BlockPos.CODEC.fieldOf("dest").forGetter(TeleportData::dest), (App)Codec.FLOAT.fieldOf("pitch").forGetter(TeleportData::pitch), (App)Codec.FLOAT.fieldOf("yaw").forGetter(TeleportData::yaw), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).optionalFieldOf("dim_id").forGetter(TeleportData::dimId)).apply((Applicative)builder, TeleportData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TeleportData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, TeleportData::enabled, (StreamCodec)ByteBufCodecs.BOOL, TeleportData::relative, (StreamCodec)BlockPos.STREAM_CODEC, TeleportData::dest, (StreamCodec)ByteBufCodecs.FLOAT, TeleportData::pitch, (StreamCodec)ByteBufCodecs.FLOAT, TeleportData::yaw, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION)), TeleportData::dimId, TeleportData::new);
        public static final TeleportData NONE = new TeleportData(false, false, BlockPos.ZERO, 0.0f, 0.0f, Optional.empty());

        public TeleportData withEnabled(boolean enabled) {
            return new TeleportData(enabled, this.relative, this.dest, this.pitch, this.yaw, this.dimId);
        }

        public TeleportData withRelative(boolean relative) {
            return new TeleportData(this.enabled, relative, this.dest, this.pitch, this.yaw, this.dimId);
        }

        public TeleportData withPitch(float pitch) {
            return new TeleportData(this.enabled, this.relative, this.dest, pitch, this.yaw, this.dimId);
        }

        public TeleportData withYaw(float yaw) {
            return new TeleportData(this.enabled, this.relative, this.dest, this.pitch, yaw, this.dimId);
        }

        public TeleportData withDimId(String dimStr) {
            return this.withDimId(dimStr.isEmpty() || ResourceLocation.tryParse((String)dimStr) == null ? null : ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dimStr)));
        }

        public TeleportData withDimId(@Nullable ResourceKey<Level> dimId) {
            return new TeleportData(this.enabled, this.relative, this.dest, this.pitch, this.yaw, Optional.ofNullable(dimId));
        }

        public TeleportData withDestPos(BlockPos pos) {
            return new TeleportData(this.enabled, this.relative, pos, this.pitch, this.yaw, this.dimId);
        }

        public TeleportData withDestX(int x) {
            return this.withDestPos(new BlockPos(x, this.dest.getY(), this.dest.getY()));
        }

        public TeleportData withDestY(int y) {
            return this.withDestPos(new BlockPos(this.dest.getX(), y, this.dest.getY()));
        }

        public TeleportData withDestZ(int z) {
            return this.withDestPos(new BlockPos(this.dest.getX(), this.dest.getY(), z));
        }

        public String dimStr() {
            return this.dimId.map(id -> id.location().toString()).orElse("");
        }

        @Nullable
        public Level getLevel(MinecraftServer server) {
            return this.dimId.map(arg_0 -> ((MinecraftServer)server).getLevel(arg_0)).orElse(null);
        }

        public TeleportData effectiveDest(BlockPos basePos) {
            return this.relative ? this.withDestPos(basePos.offset((Vec3i)this.dest)) : this;
        }

        public void teleportPlayer(ServerPlayer player) {
            if (player != null && player.getServer() != null && this.enabled) {
                Vec3 dest = this.dest().getBottomCenter();
                Level destLevel = Objects.requireNonNullElse(this.getLevel(player.getServer()), player.level());
                if (destLevel instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)destLevel;
                    player.teleportTo(serverLevel, dest.x, dest.y, dest.z, this.yaw(), this.pitch());
                    Holder sound = BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.PLAYER_TELEPORT);
                    player.connection.send((Packet)new ClientboundSoundPacket(sound, SoundSource.PLAYERS, dest.x, dest.y, dest.z, 0.5f, 1.0f, serverLevel.getRandom().nextLong()));
                }
            }
        }
    }

    public record BarrierSavedData(String objStr, ItemStack skin, boolean invisibleWhenOpen, Optional<TeleportData> teleportData) {
        public static final BarrierSavedData DEFAULT = new BarrierSavedData("", ItemStack.EMPTY, false, Optional.empty());
        public static final Codec<BarrierSavedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.optionalFieldOf("object", (Object)"").forGetter(BarrierSavedData::objStr), (App)ItemStack.CODEC.optionalFieldOf("skin", (Object)ItemStack.EMPTY).forGetter(BarrierSavedData::skin), (App)Codec.BOOL.optionalFieldOf("invis_when_open", (Object)false).forGetter(BarrierSavedData::invisibleWhenOpen), (App)TeleportData.CODEC.optionalFieldOf("teleport").forGetter(BarrierSavedData::teleportData)).apply((Applicative)builder, BarrierSavedData::new));
        public static StreamCodec<RegistryFriendlyByteBuf, BarrierSavedData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, BarrierSavedData::objStr, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, BarrierSavedData::skin, (StreamCodec)ByteBufCodecs.BOOL, BarrierSavedData::invisibleWhenOpen, (StreamCodec)ByteBufCodecs.optional(TeleportData.STREAM_CODEC), BarrierSavedData::teleportData, BarrierSavedData::new);

        public static BarrierSavedData fromBlockEntity(BaseBarrierBlockEntity b) {
            return new BarrierSavedData(b.objStr, b.skin, b.invisibleWhenOpen, b.optionalTeleportData());
        }

        public void addTooltipInfo(BarrierSavedData data, List<Component> tooltip, String what) {
            tooltip.add((Component)Component.translatable((String)("item.ftbquests.barrier.object." + what), (Object[])new Object[]{data.objStr().isEmpty() ? "-" : data.objStr}).withStyle(ChatFormatting.GRAY));
            if (Platform.isForgeLike() && !data.skin().isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"item.ftbquests.barrier.skin", (Object[])new Object[]{data.skin().getDisplayName()}).withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.translatable((String)"item.ftbquests.barrier.invis_when_open", (Object[])new Object[]{data.invisibleWhenOpen()}).withStyle(ChatFormatting.GRAY));
        }
    }
}

