/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.client.gui.ConfigInfoPage;
import com.cazsius.solcarrot.client.gui.FoodData;
import com.cazsius.solcarrot.client.gui.ItemListPage;
import com.cazsius.solcarrot.client.gui.Page;
import com.cazsius.solcarrot.client.gui.PageFlipButton;
import com.cazsius.solcarrot.client.gui.StatListPage;
import com.cazsius.solcarrot.client.gui.elements.ImageData;
import com.cazsius.solcarrot.client.gui.elements.UIElement;
import com.cazsius.solcarrot.client.gui.elements.UIImage;
import com.cazsius.solcarrot.client.gui.elements.UILabel;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodList;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class FoodBookScreen
extends Screen
implements PageFlipButton.Pageable {
    private static final ResourceLocation texture = SOLCarrot.resourceLocation("textures/gui/food_book.png");
    private static final ImageData bookImage = new ImageData(texture, new Rectangle(0, 0, 186, 192));
    static final ImageData carrotImage = new ImageData(texture, new Rectangle(0, 240, 16, 16), 14, 14);
    static final ImageData spiderEyeImage = new ImageData(texture, new Rectangle(16, 240, 16, 16), 8, 8);
    static final ImageData heartImage = new ImageData(texture, new Rectangle(0, 224, 15, 15), 9, 9);
    static final ImageData drumstickImage = new ImageData(texture, new Rectangle(16, 224, 15, 15), 9, 9);
    static final ImageData blacklistImage = new ImageData(texture, new Rectangle(32, 224, 15, 15), 10, 12);
    static final ImageData whitelistImage = new ImageData(texture, new Rectangle(48, 224, 15, 15), 10, 12);
    static final Color fullBlack = Color.BLACK;
    static final Color lessBlack = new Color(0, 0, 0, 128);
    static final Color leastBlack = new Color(0, 0, 0, 64);
    private final List<UIElement> elements = new ArrayList<UIElement>();
    private UIImage background;
    private UILabel pageNumberLabel;
    private PageFlipButton nextPageButton;
    private PageFlipButton prevPageButton;
    private Player player;
    private FoodData foodData;
    private final List<Page> pages = new ArrayList<Page>();
    private int currentPageNumber = 0;

    public static void open(Player player) {
        Minecraft.getInstance().setScreen((Screen)new FoodBookScreen(player));
    }

    public FoodBookScreen(Player player) {
        super((Component)Component.empty());
        this.player = player;
    }

    public void init() {
        super.init();
        this.foodData = new FoodData(FoodList.get(this.player));
        this.background = new UIImage(bookImage);
        this.background.setCenterX(this.width / 2);
        this.background.setCenterY(this.height / 2);
        this.elements.clear();
        this.pageNumberLabel = new UILabel("1");
        this.pageNumberLabel.setCenterX(this.background.getCenterX());
        this.pageNumberLabel.setMinY(this.background.getMinY() + 156);
        this.elements.add(this.pageNumberLabel);
        this.initPages();
        int pageFlipButtonSpacing = 50;
        this.prevPageButton = (PageFlipButton)this.addRenderableWidget((GuiEventListener)new PageFlipButton(this.background.getCenterX() - pageFlipButtonSpacing / 2 - 23, this.background.getMinY() + 152, PageFlipButton.Direction.BACKWARD, this));
        this.nextPageButton = (PageFlipButton)this.addRenderableWidget((GuiEventListener)new PageFlipButton(this.background.getCenterX() + pageFlipButtonSpacing / 2, this.background.getMinY() + 152, PageFlipButton.Direction.FORWARD, this));
        this.updateButtonVisibility();
    }

    private void initPages() {
        this.pages.clear();
        this.pages.add(new StatListPage(this.foodData, this.background.frame));
        this.pages.add(new ConfigInfoPage(this.foodData, this.background.frame));
        this.addPages("eaten_foods", this.foodData.eatenFoods);
        if (SOLCarrotConfig.shouldShowUneatenFoods()) {
            this.addPages("uneaten_foods", this.foodData.uneatenFoods);
        }
    }

    private void addPages(String headerLocalizationPath, List<Item> items) {
        String header = Localization.localized("gui", "food_book." + headerLocalizationPath, items.size());
        List<ItemStack> stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        this.pages.addAll(ItemListPage.pages(this.background.frame, header, stacks));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (!this.pages.isEmpty()) {
            UIElement.render(graphics, this.elements, mouseX, mouseY);
            UIElement.render(graphics, this.pages.get(this.currentPageNumber), mouseX, mouseY);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        UIElement.render(guiGraphics, this.background, mouseX, mouseY);
    }

    @Override
    public void switchToPage(int pageNumber) {
        if (!this.isWithinRange(pageNumber)) {
            return;
        }
        this.currentPageNumber = pageNumber;
        this.updateButtonVisibility();
        this.pageNumberLabel.text = "" + (this.currentPageNumber + 1);
    }

    @Override
    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    @Override
    public boolean isWithinRange(int pageNumber) {
        return pageNumber >= 0 && pageNumber < this.pages.size();
    }

    private void updateButtonVisibility() {
        this.prevPageButton.updateState();
        this.nextPageButton.updateState();
    }
}

